import { TextDocument } from "vscode-languageserver-textdocument";
import { ELsCodeCompletionStrategy, ELsJsonPath, ELsNode } from "./types";
import { CompletionItem, CompletionItemKind, Position, Range } from "vscode-languageserver-types";
export declare type EditorLanguageServiceCodeCompletionFunctionsArgs = {
    codeCompletionStrategy: ELsCodeCompletionStrategy;
    currentNode: ELsNode;
    currentNodeRange: Range;
    cursorOffset: number;
    cursorPosition: Position;
    document: TextDocument;
    overwriteRange: Range;
    rootNode: ELsNode;
};
export declare type EditorLanguageServiceEmptyFileCodeCompletionFunctionArgs = {
    cursorPosition: Position;
    codeCompletionStrategy: ELsCodeCompletionStrategy;
    cursorOffset: number;
    document: TextDocument;
};
export declare type ELsCompletionsMap<ARGS extends EditorLanguageServiceCodeCompletionFunctionsArgs> = Map<ELsJsonPath | null, (args: ARGS | EditorLanguageServiceEmptyFileCodeCompletionFunctionArgs) => Promise<CompletionItem[]>>;
export declare function createCompletionItem(args: {
    codeCompletionStrategy: ELsCodeCompletionStrategy;
    completion: object | string;
    currentNodeRange: Range;
    cursorOffset: number;
    document: TextDocument;
    detail: string;
    extraOptions?: Partial<CompletionItem>;
    kind: CompletionItemKind;
    label: string;
    overwriteRange: Range;
    filterText?: string;
}): CompletionItem;
export declare type EditorLanguageServiceCodeCompletionFunctions = {
    [name: string]: (args: EditorLanguageServiceCodeCompletionFunctionsArgs) => Promise<CompletionItem[]>;
    getEmptyFileCodeCompletions: (args: EditorLanguageServiceEmptyFileCodeCompletionFunctionArgs) => Promise<CompletionItem[]>;
};
//# sourceMappingURL=EditorLanguageServiceCodeCompletion.d.ts.map