import * as React from "react";
import * as DmnEditor from "@kie-tools/dmn-editor/dist/DmnEditor";
import { Normalized } from "@kie-tools/dmn-editor/dist/normalization/normalize";
import { DMN_LATEST_VERSION, DmnLatestModel, DmnMarshaller } from "@kie-tools/dmn-marshaller";
import { WorkspaceChannelApi, WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { KeyboardShortcutsService } from "@kie-tools-core/keyboard-shortcuts/dist/envelope/KeyboardShortcutsService";
export declare const EXTERNAL_MODELS_SEARCH_GLOB_PATTERN = "**/*.{dmn,pmml}";
export declare const EMPTY_DMN: () => string;
export declare type DmnEditorRootProps = {
    exposing: (s: DmnEditorRoot) => void;
    onNewEdit: (edit: WorkspaceEdit) => void;
    onRequestWorkspaceFilesList: WorkspaceChannelApi["kogitoWorkspace_resourceListRequest"];
    onRequestWorkspaceFileContent: WorkspaceChannelApi["kogitoWorkspace_resourceContentRequest"];
    onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot: WorkspaceChannelApi["kogitoWorkspace_openFile"];
    workspaceRootAbsolutePosixPath: string;
    keyboardShortcutsService: KeyboardShortcutsService | undefined;
};
export declare type DmnEditorRootState = {
    marshaller: DmnMarshaller<typeof DMN_LATEST_VERSION> | undefined;
    stack: Normalized<DmnLatestModel>[];
    pointer: number;
    openFilenormalizedPosixPathRelativeToTheWorkspaceRoot: string | undefined;
    externalModelsByNamespace: DmnEditor.ExternalModelsIndex;
    readonly: boolean;
    externalModelsManagerDoneBootstraping: boolean;
    keyboardShortcutsRegisterIds: number[];
    keyboardShortcutsRegistred: boolean;
    error: Error | undefined;
};
export declare class DmnEditorRoot extends React.Component<DmnEditorRootProps, DmnEditorRootState> {
    private readonly externalModelsManagerDoneBootstraping;
    private readonly dmnEditorRef;
    constructor(props: DmnEditorRootProps);
    undo(): Promise<void>;
    redo(): Promise<void>;
    getDiagramSvg(): Promise<string | undefined>;
    getContent(): Promise<string>;
    setContent(openFilenormalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    get model(): Normalized<DmnLatestModel> | undefined;
    private getMarshaller;
    private setExternalModelsByNamespace;
    private onModelChange;
    private onRequestExternalModelsAvailableToInclude;
    private onRequestToResolvePathRelativeToTheOpenFile;
    private onRequestExternalModelByPathsRelativeToTheOpenFile;
    private onOpenFileFromPathRelativeToTheOpenFile;
    componentDidUpdate(prevProps: Readonly<DmnEditorRootProps>, prevState: Readonly<DmnEditorRootState>, snapshot?: any): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
}
//# sourceMappingURL=DmnEditorRoot.d.ts.map