import "@patternfly/react-core/dist/styles/base.css";
import * as React from "react";
import { SceSim__FactMappingType } from "@kie-tools/scesim-marshaller/dist/schemas/scesim-1_8/ts-gen/types";
import "./TestScenarioEditor.css";
export declare enum TestScenarioEditorDock {
    CHEATSHEET = 0,
    DATA_OBJECT = 1,
    SETTINGS = 2
}
export declare enum TestScenarioType {
    DMN = 0,
    RULE = 1
}
export declare type TestScenarioAlert = {
    enabled: boolean;
    message?: string;
    variant: "success" | "danger" | "warning" | "info" | "default";
};
export declare type TestScenarioDataObject = {
    id: string;
    children?: TestScenarioDataObject[];
    customBadgeContent?: string;
    isSimpleTypeFact?: boolean;
    name: string;
};
export declare type TestScenarioEditorRef = {
    getContent(): string;
    getDiagramSvg: () => Promise<string | undefined>;
    setContent(pathRelativeToTheWorkspaceRoot: string, content: string): void;
};
export declare type TestScenarioSettings = {
    assetType: string;
    dmnFilePath?: string;
    dmnName?: string;
    dmnNamespace?: string;
    isStatelessSessionRule?: boolean;
    isTestSkipped: boolean;
    kieSessionRule?: string;
    ruleFlowGroup?: string;
};
export declare type TestScenarioSelectedColumnMetaData = {
    factMapping: SceSim__FactMappingType;
    index: number;
    isBackground: boolean;
};
export declare const TestScenarioEditor: React.ForwardRefExoticComponent<React.RefAttributes<TestScenarioEditorRef>>;
//# sourceMappingURL=TestScenarioEditor.d.ts.map