<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

# kn-plugin-workflow

`kn-plugin-workflow` is a plugin of the Knative Client, to enable users to quickly set up a local SonataFlow project from the command line.

[Read the documentation](https://sonataflow.org/serverlessworkflow/main/testing-and-troubleshooting/kn-plugin-workflow-overview.html)

## Build from source

All the commands in this section should be performed in the monorepo root.

### Prerequisites

- Node `>= 20.14.0` _(To install, follow these instructions: https://nodejs.org/en/download/package-manager/)_
- pnpm `9.3.0` _(To install, follow these instructions: https://pnpm.io/installation)_
- Go `1.21.9` _(To install, follow these instructions: https://go.dev/doc/install)_

#### Prerequisites for running end-to-end tests

- docker _(To install, follow these instructions: https://docs.docker.com/engine/install)_
- podman _(To install, follow these instructions: https://podman.io/docs/installation)_

### Installing and linking dependencies

The following command will install the `kn-plugin-workflow` dependencies and link it with any other monorepo
package that is listed in the `package.json`:

- `pnpm bootstrap -F "@kie-tools/kn-plugin-workflow..."`

### Building

It has two different strategies to build the `kn-plugin-workflow`:

- `build:dev` _(The build will generate one artifact that is compatible with your local machine)_
- `build:prod` _(The build will generate artifacts for all available architecture and run the available tests)_

To build the `kn-plugin-workflow` run the following command:

- `pnpm -r -F "@kie-tools/kn-plugin-workflow..." <build-strategy>`

#### Plugin/artifact location

The artifact(s) generated by running the above command are placed in the `packages/kn-plugin-workflow/dist` directory.

### End to End Tests

To build the `kn-plugin-workflow` and run end-to-end tests, use the following commands:

- `export KIE_TOOLS_BUILD__runEndToEndTests=true`
- `pnpm -r -F "@kie-tools/kn-plugin-workflow..." build:prod`

---

Apache KIE (incubating) is an effort undergoing incubation at The Apache Software
Foundation (ASF), sponsored by the name of Apache Incubator. Incubation is
required of all newly accepted projects until a further review indicates that
the infrastructure, communications, and decision making process have stabilized
in a manner consistent with other successful ASF projects. While incubation
status is not necessarily a reflection of the completeness or stability of the
code, it does indicate that the project has yet to be fully endorsed by the ASF.

Some of the incubating project’s releases may not be fully compliant with ASF
policy. For example, releases may have incomplete or un-reviewed licensing
conditions. What follows is a list of known issues the project is currently
aware of (note that this list, by definition, is likely to be incomplete):

- Hibernate, an LGPL project, is being used. Hibernate is in the process of relicensing to ASL v2
- Some files, particularly test files, and those not supporting comments, may be missing the ASF Licensing Header
-

- Hibernate, an LGPL project, is being used. Hibernate is in the process of
  relicensing to ASL v2
- Some files, particularly test files, and those not supporting comments, may
  be missing the ASF Licensing Header

If you are planning to incorporate this work into your product/project, please
be aware that you will need to conduct a thorough licensing review to determine
the overall implications of including this work. For the current status of this
project through the Apache Incubator visit:
https://incubator.apache.org/projects/kie.html
