/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.type;

import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;
import org.apache.ignite.shaded.org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.shaded.org.apache.ignite.sql.ColumnType;

public class VarlenNativeType
extends NativeType {
    private final int len;

    VarlenNativeType(ColumnType typeSpec, int len) {
        super(typeSpec);
        this.len = len;
    }

    @Override
    public boolean mismatch(NativeType type) {
        return super.mismatch(type) || this.len < ((VarlenNativeType)type).len;
    }

    @Override
    public String displayName() {
        return IgniteStringFormatter.format("{}({})", super.displayName(), this.len);
    }

    public int length() {
        return this.len;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VarlenNativeType that = (VarlenNativeType)o;
        return this.len == that.len;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.len);
    }

    @Override
    public String toString() {
        return S.toString(VarlenNativeType.class.getSimpleName(), "name", (Object)this.spec(), "len", (Object)this.len);
    }
}

