/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestSharedOutputBuffer {
    private static final Timeout TIMEOUT = Timeout.ofMinutes((long)1L);

    TestSharedOutputBuffer() {
    }

    @Test
    void testBasis() throws Exception {
        Charset charset = StandardCharsets.US_ASCII;
        SharedOutputBuffer outputBuffer = new SharedOutputBuffer(30);
        WritableByteChannelMock channel = new WritableByteChannelMock(1024);
        DataStreamChannel dataStreamChannel = (DataStreamChannel)Mockito.spy((Object)new DataStreamChannelMock(channel));
        outputBuffer.flush(dataStreamChannel);
        Mockito.verifyNoInteractions((Object[])new Object[]{dataStreamChannel});
        Assertions.assertEquals((int)0, (int)outputBuffer.length());
        Assertions.assertEquals((int)30, (int)outputBuffer.capacity());
        byte[] tmp = "1234567890".getBytes(charset);
        outputBuffer.write(tmp, 0, tmp.length);
        outputBuffer.write(tmp, 0, tmp.length);
        outputBuffer.write(49);
        outputBuffer.write(50);
        Assertions.assertEquals((int)22, (int)outputBuffer.length());
        Assertions.assertEquals((int)8, (int)outputBuffer.capacity());
        Mockito.verifyNoInteractions((Object[])new Object[]{dataStreamChannel});
    }

    @Test
    void testFlush() throws Exception {
        Charset charset = StandardCharsets.US_ASCII;
        SharedOutputBuffer outputBuffer = new SharedOutputBuffer(30);
        WritableByteChannelMock channel = new WritableByteChannelMock(1024);
        DataStreamChannelMock dataStreamChannel = new DataStreamChannelMock(channel);
        outputBuffer.flush((DataStreamChannel)dataStreamChannel);
        Assertions.assertEquals((int)0, (int)outputBuffer.length());
        Assertions.assertEquals((int)30, (int)outputBuffer.capacity());
        byte[] tmp = "1234567890".getBytes(charset);
        outputBuffer.write(tmp, 0, tmp.length);
        outputBuffer.write(tmp, 0, tmp.length);
        outputBuffer.write(49);
        outputBuffer.write(50);
        outputBuffer.flush((DataStreamChannel)dataStreamChannel);
        Assertions.assertEquals((int)0, (int)outputBuffer.length());
        Assertions.assertEquals((int)30, (int)outputBuffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=20)
    void testMultithreadingWriteStream() throws Exception {
        Charset charset = StandardCharsets.US_ASCII;
        SharedOutputBuffer outputBuffer = new SharedOutputBuffer(20);
        WritableByteChannelMock channel = new WritableByteChannelMock(1024);
        DataStreamChannelMock dataStreamChannel = new DataStreamChannelMock(channel);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            Future<Boolean> task1 = executorService.submit(() -> {
                byte[] tmp = "1234567890".getBytes(charset);
                outputBuffer.write(tmp, 0, tmp.length);
                outputBuffer.write(tmp, 0, tmp.length);
                outputBuffer.write(49);
                outputBuffer.write(50);
                outputBuffer.write(tmp, 0, tmp.length);
                outputBuffer.write(tmp, 0, tmp.length);
                outputBuffer.write(tmp, 0, tmp.length);
                outputBuffer.writeCompleted();
                outputBuffer.writeCompleted();
                return Boolean.TRUE;
            });
            Future<Boolean> task2 = executorService.submit(() -> {
                do {
                    outputBuffer.flush((DataStreamChannel)dataStreamChannel);
                } while (!outputBuffer.isEndStream());
                return Boolean.TRUE;
            });
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
            Assertions.assertEquals((Object)"1234567890123456789012123456789012345678901234567890", (Object)new String(channel.toByteArray(), charset));
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    void testMultithreadingWriteStreamAbort() throws Exception {
        Charset charset = StandardCharsets.US_ASCII;
        SharedOutputBuffer outputBuffer = new SharedOutputBuffer(20);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Boolean> task1 = executorService.submit(() -> {
            byte[] tmp = "1234567890".getBytes(charset);
            for (int i = 0; i < 20; ++i) {
                outputBuffer.write(tmp, 0, tmp.length);
            }
            outputBuffer.writeCompleted();
            return Boolean.TRUE;
        });
        Future<Boolean> task2 = executorService.submit(() -> {
            Thread.sleep(200L);
            outputBuffer.abort();
            return Boolean.TRUE;
        });
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        try {
            task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit());
        }
        catch (ExecutionException ex) {
            Assertions.assertTrue((boolean)(ex.getCause() instanceof InterruptedIOException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testEndStreamOnlyCalledOnce() throws Exception {
        SharedOutputBuffer outputBuffer = new SharedOutputBuffer(20);
        WritableByteChannelMock channel = new WritableByteChannelMock(1024);
        DataStreamChannelMock dataStreamChannel = (DataStreamChannelMock)Mockito.spy((Object)new DataStreamChannelMock(channel));
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            Future<Boolean> task1 = executorService.submit(() -> {
                outputBuffer.writeCompleted();
                return Boolean.TRUE;
            });
            Future<Boolean> task2 = executorService.submit(() -> {
                do {
                    outputBuffer.flush((DataStreamChannel)dataStreamChannel);
                } while (!outputBuffer.isEndStream());
                return Boolean.TRUE;
            });
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
            ((DataStreamChannelMock)Mockito.verify((Object)dataStreamChannel, (VerificationMode)Mockito.times((int)1))).endStream();
        }
        finally {
            executorService.shutdownNow();
        }
    }

    static class DataStreamChannelMock
    implements DataStreamChannel {
        private final WritableByteChannelMock channel;
        private final ReentrantLock lock;

        DataStreamChannelMock(WritableByteChannelMock channel) {
            this.channel = channel;
            this.lock = new ReentrantLock();
        }

        public int write(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                int n = this.channel.write(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void requestOutput() {
        }

        public void endStream(List<? extends Header> trailers) throws IOException {
            this.lock.lock();
            try {
                this.channel.close();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void endStream() throws IOException {
            this.endStream(null);
        }
    }
}

