/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.snmptrap;

import java.net.InetAddress;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.w3c.dom.Node;

@Action(id="SNMP_TRAP", name="i18n::ActionSNMPTrap.Name", description="i18n::ActionSNMPTrap.Description", image="SNMP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionSNMPTrap.keyword"}, documentationUrl="/workflow/actions/snmptrap.html")
public class ActionSNMPTrap
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSNMPTrap.class;
    private String serverName = null;
    private String port = "162";
    private String timeout = "5000";
    private String nrretry = "1";
    private String comString = "public";
    private String message = null;
    private String oid = null;
    private String targettype = targetTypeCode[0];
    private String user = null;
    private String passphrase = null;
    private String engineid = null;
    private static final int DEFAULT_RETRIES = 1;
    private static final int DEFAULT_TIME_OUT = 5000;
    public static final int DEFAULT_PORT = 162;
    public static final String[] targetTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TargetType.Community", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TargetType.User", (String[])new String[0])};
    public static final String[] targetTypeCode = new String[]{"community", "user"};

    public ActionSNMPTrap(String n) {
        super(n, "");
    }

    public ActionSNMPTrap() {
        this("");
    }

    public Object clone() {
        ActionSNMPTrap je = (ActionSNMPTrap)super.clone();
        return je;
    }

    public String getTargetTypeDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return targetTypeDesc[0];
        }
        if (tt.equalsIgnoreCase(targetTypeCode[1])) {
            return targetTypeDesc[1];
        }
        return targetTypeDesc[0];
    }

    public String getTargetTypeCode(String tt) {
        if (tt == null) {
            return targetTypeCode[0];
        }
        if (tt.equals(targetTypeDesc[1])) {
            return targetTypeCode[1];
        }
        return targetTypeCode[0];
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"oid", (String)this.oid));
        retval.append("      ").append(XmlHandler.addTagValue((String)"comstring", (String)this.comString));
        retval.append("      ").append(XmlHandler.addTagValue((String)"message", (String)this.message));
        retval.append("      ").append(XmlHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nrretry", (String)this.nrretry));
        retval.append("      ").append(XmlHandler.addTagValue((String)"targettype", (String)this.targettype));
        retval.append("      ").append(XmlHandler.addTagValue((String)"user", (String)this.user));
        retval.append("      ").append(XmlHandler.addTagValue((String)"passphrase", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.passphrase)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"engineid", (String)this.engineid));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.port = XmlHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.oid = XmlHandler.getTagValue((Node)entrynode, (String)"oid");
            this.message = XmlHandler.getTagValue((Node)entrynode, (String)"message");
            this.comString = XmlHandler.getTagValue((Node)entrynode, (String)"comstring");
            this.timeout = XmlHandler.getTagValue((Node)entrynode, (String)"timeout");
            this.nrretry = XmlHandler.getTagValue((Node)entrynode, (String)"nrretry");
            this.targettype = XmlHandler.getTagValue((Node)entrynode, (String)"targettype");
            this.user = XmlHandler.getTagValue((Node)entrynode, (String)"user");
            this.passphrase = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"passphrase"));
            this.engineid = XmlHandler.getTagValue((Node)entrynode, (String)"engineid");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'SNMPTrap' from XML node", (Throwable)xe);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public String getComString() {
        return this.comString;
    }

    public void setComString(String comString) {
        this.comString = comString;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassPhrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getPassPhrase() {
        return this.passphrase;
    }

    public void setEngineID(String engineid) {
        this.engineid = engineid;
    }

    public String getEngineID() {
        return this.engineid;
    }

    public String getTargetType() {
        return this.targettype;
    }

    public void setTargetType(String targettypein) {
        this.targettype = this.getTargetTypeCode(targettypein);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setRetry(String nrretry) {
        this.nrretry = nrretry;
    }

    public String getRetry() {
        return this.nrretry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String servername = this.resolve(this.serverName);
        int nrPort = Const.toInt((String)this.resolve(this.port), (int)162);
        String oid = this.resolve(this.oid);
        int timeOut = Const.toInt((String)this.resolve(this.timeout), (int)5000);
        int retry = Const.toInt((String)this.resolve(this.nrretry), (int)1);
        String messageString = this.resolve(this.message);
        Snmp snmp = null;
        try {
            DefaultUdpTransportMapping transMap = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transMap);
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(servername), nrPort);
            ResponseEvent response = null;
            if (this.targettype.equals(targetTypeCode[0])) {
                String community = this.resolve(this.comString);
                CommunityTarget target = new CommunityTarget();
                PDUv1 pdu1 = new PDUv1();
                transMap.listen();
                target.setCommunity(new OctetString(community));
                target.setVersion(0);
                target.setAddress((Address)udpAddress);
                if (target.getAddress().isValid()) {
                    if (this.log.isDebug()) {
                        this.logDebug("Valid IP address");
                    }
                } else {
                    throw new HopException("Invalid IP address");
                }
                target.setRetries(retry);
                target.setTimeout((long)timeOut);
                pdu1.setGenericTrap(6);
                pdu1.setSpecificTrap(6);
                pdu1.setEnterprise(new OID(oid));
                pdu1.add(new VariableBinding(new OID(oid), (Variable)new OctetString(messageString)));
                response = snmp.send((PDU)pdu1, (Target)target);
            } else {
                String userName = this.resolve(this.user);
                String passPhrase = this.resolve(this.passphrase);
                String engineID = this.resolve(this.engineid);
                UserTarget usertarget = new UserTarget();
                transMap.listen();
                usertarget.setAddress((Address)udpAddress);
                if (usertarget.getAddress().isValid()) {
                    if (this.log.isDebug()) {
                        this.logDebug("Valid IP address");
                    }
                } else {
                    throw new HopException("Invalid IP address");
                }
                usertarget.setRetries(retry);
                usertarget.setTimeout((long)timeOut);
                usertarget.setVersion(3);
                usertarget.setSecurityLevel(3);
                usertarget.setSecurityName(new OctetString("MD5DES"));
                UsmUser uu = new UsmUser(new OctetString(userName), AuthMD5.ID, new OctetString(passPhrase), PrivDES.ID, new OctetString(passPhrase));
                USM usm = snmp.getUSM();
                if (usm == null) {
                    throw new HopException("Null Usm");
                }
                usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                usm.addUser(new OctetString(userName), uu);
                if (this.log.isDebug()) {
                    this.logDebug("Valid Usm");
                }
                ScopedPDU pdu = new ScopedPDU();
                pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString(messageString)));
                pdu.setType(-89);
                if (!Utils.isEmpty((CharSequence)engineID)) {
                    pdu.setContextEngineID(new OctetString(engineID));
                }
                response = snmp.send((PDU)pdu, (Target)usertarget);
            }
            if (response != null && this.log.isDebug()) {
                this.logDebug("Received response from: " + String.valueOf(response.getPeerAddress()) + response.toString());
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.ErrorGetting", (String[])new String[]{e.getMessage()}));
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }
}

