/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ssh.Ssh;
import org.apache.hop.pipeline.transforms.ssh.SshData;

@Transform(id="SSH", image="ssh.svg", name="i18n::SSH.Name", description="i18n::SSH.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::SSHMeta.keyword"}, documentationUrl="/pipeline/transforms/runssh.html")
public class SshMeta
extends BaseTransformMeta<Ssh, SshData> {
    static Class<?> PKG = SshMeta.class;
    private static int DEFAULT_PORT = 22;
    @HopMetadataProperty
    private String command = null;
    @HopMetadataProperty
    private boolean dynamicCommandField = false;
    @HopMetadataProperty(key="commandfieldname")
    private String commandFieldName = null;
    @HopMetadataProperty
    private String serverName = null;
    @HopMetadataProperty
    private String port = String.valueOf(DEFAULT_PORT);
    @HopMetadataProperty
    private String userName = null;
    @HopMetadataProperty(password=true)
    private String password = null;
    @HopMetadataProperty
    private boolean usePrivateKey = true;
    @HopMetadataProperty
    private String keyFileName = null;
    @HopMetadataProperty(password=true)
    private String passPhrase;
    @HopMetadataProperty
    private String stdOutFieldName = "stdOut";
    @HopMetadataProperty
    private String stdErrFieldName = "stdErr";
    @HopMetadataProperty
    private String timeOut = "0";
    @HopMetadataProperty
    private String proxyHost = null;
    @HopMetadataProperty
    private String proxyPort = null;
    @HopMetadataProperty
    private String proxyUsername = null;
    @HopMetadataProperty(password=true)
    private String proxyPassword = null;

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.getServerName())) {
            errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.TargetHostMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.TargetHostOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isUsePrivateKey()) {
            String keyfilename = variables.resolve(this.getKeyFileName());
            if (Utils.isEmpty((CharSequence)keyfilename)) {
                errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNameMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNameOK", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                boolean keyFileExists = false;
                try {
                    keyFileExists = HopVfs.fileExists((String)keyfilename);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!keyFileExists) {
                    errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNotExist", (String[])new String[]{keyfilename});
                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileExists", (String[])new String[]{keyfilename});
                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.isDynamicCommandField()) {
            row.clear();
        }
        ValueMetaString v = new ValueMetaString(variables.resolve(this.getStdOutFieldName()));
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
        String stderrfield = variables.resolve(this.getStdErrFieldName());
        if (!Utils.isEmpty((CharSequence)stderrfield)) {
            v = new ValueMetaBoolean(stderrfield);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isDynamicCommandField() {
        return this.dynamicCommandField;
    }

    public void setDynamicCommandField(boolean dynamicCommandField) {
        this.dynamicCommandField = dynamicCommandField;
    }

    public String getCommandFieldName() {
        return this.commandFieldName;
    }

    public void setCommandFieldName(String commandFieldName) {
        this.commandFieldName = commandFieldName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUsePrivateKey() {
        return this.usePrivateKey;
    }

    public void setUsePrivateKey(boolean usePrivateKey) {
        this.usePrivateKey = usePrivateKey;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setKeyFileName(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getStdOutFieldName() {
        return this.stdOutFieldName;
    }

    public void setStdOutFieldName(String stdOutFieldName) {
        this.stdOutFieldName = stdOutFieldName;
    }

    public String getStdErrFieldName() {
        return this.stdErrFieldName;
    }

    public void setStdErrFieldName(String stdErrFieldName) {
        this.stdErrFieldName = stdErrFieldName;
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(String timeOut) {
        this.timeOut = timeOut;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

