/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BigtableDataClient
implements AutoCloseable {
    private final EnhancedBigtableStub stub;

    public static BigtableDataClient create(String projectId, String instanceId) throws IOException {
        BigtableDataSettings settings = BigtableDataSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).build();
        return BigtableDataClient.create(settings);
    }

    public static BigtableDataClient create(BigtableDataSettings settings) throws IOException {
        EnhancedBigtableStub stub = EnhancedBigtableStub.create(settings.getStubSettings());
        return new BigtableDataClient(stub);
    }

    @InternalApi(value="Visible for testing")
    BigtableDataClient(EnhancedBigtableStub stub) {
        this.stub = stub;
    }

    public boolean exists(String tableId, String rowKey) {
        return (Boolean)ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId, rowKey));
    }

    public boolean exists(String tableId, ByteString rowKey) {
        return (Boolean)ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId, rowKey));
    }

    public ApiFuture<Boolean> existsAsync(String tableId, String rowKey) {
        return this.existsAsync(tableId, ByteString.copyFromUtf8((String)rowKey));
    }

    public ApiFuture<Boolean> existsAsync(String tableId, ByteString rowKey) {
        Query query = Query.create(tableId).rowKey(rowKey).filter(Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerRow(1)).filter(Filters.FILTERS.value().strip()));
        ApiFuture resultFuture = this.stub.readRowCallable().futureCall((Object)query);
        return ApiFutures.transform((ApiFuture)resultFuture, (ApiFunction)new ApiFunction<Row, Boolean>(){

            public Boolean apply(Row row) {
                return row != null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Row readRow(String tableId, ByteString rowKey) {
        return (Row)ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, rowKey, null));
    }

    public Row readRow(String tableId, String rowKey) {
        return (Row)ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, ByteString.copyFromUtf8((String)rowKey), null));
    }

    public Row readRow(String tableId, String rowKey, @Nullable Filters.Filter filter) {
        return (Row)ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, ByteString.copyFromUtf8((String)rowKey), filter));
    }

    public Row readRow(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        return (Row)ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, rowKey, filter));
    }

    public ApiFuture<Row> readRowAsync(String tableId, String rowKey) {
        return this.readRowAsync(tableId, ByteString.copyFromUtf8((String)rowKey), null);
    }

    public ApiFuture<Row> readRowAsync(String tableId, ByteString rowKey) {
        return this.readRowAsync(tableId, rowKey, null);
    }

    public ApiFuture<Row> readRowAsync(String tableId, String rowKey, @Nullable Filters.Filter filter) {
        return this.readRowAsync(tableId, ByteString.copyFromUtf8((String)rowKey), filter);
    }

    public ApiFuture<Row> readRowAsync(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        Query query = Query.create(tableId).rowKey(rowKey);
        if (filter != null) {
            query = query.filter(filter);
        }
        return this.readRowCallable().futureCall((Object)query);
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.stub.readRowCallable();
    }

    public <RowT> UnaryCallable<Query, RowT> readRowCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowCallable(rowAdapter);
    }

    public ServerStream<Row> readRows(Query query) {
        return this.readRowsCallable().call((Object)query);
    }

    public void readRowsAsync(Query query, ResponseObserver<Row> observer) {
        this.readRowsCallable().call((Object)query, observer);
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public <RowT> ServerStreamingCallable<Query, RowT> readRowsCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowsCallable(rowAdapter);
    }

    public List<KeyOffset> sampleRowKeys(String tableId) {
        return (List)ApiExceptions.callAndTranslateApiException(this.sampleRowKeysAsync(tableId));
    }

    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        return this.sampleRowKeysCallable().futureCall((Object)tableId);
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.stub.sampleRowKeysCallable();
    }

    public void mutateRow(RowMutation rowMutation) {
        ApiExceptions.callAndTranslateApiException(this.mutateRowAsync(rowMutation));
    }

    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        return this.mutateRowCallable().futureCall((Object)rowMutation);
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.stub.mutateRowCallable();
    }

    public void bulkMutateRows(BulkMutation mutation) {
        ApiExceptions.callAndTranslateApiException(this.bulkMutateRowsAsync(mutation));
    }

    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(@Nonnull String tableId) {
        return this.newBulkMutationBatcher(tableId, null);
    }

    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        return this.stub.newMutateRowsBatcher(tableId, ctx);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId) {
        return this.newBulkReadRowsBatcher(tableId, null);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId, @Nullable Filters.Filter filter) {
        return this.newBulkReadRowsBatcher(tableId, filter, null);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId, @Nullable Filters.Filter filter, @Nullable GrpcCallContext ctx) {
        Query query = Query.create(tableId);
        if (filter != null) {
            query.filter(filter);
        }
        return this.stub.newBulkReadRowsBatcher(query, ctx);
    }

    public ApiFuture<Void> bulkMutateRowsAsync(BulkMutation mutation) {
        return this.bulkMutationCallable().futureCall((Object)mutation);
    }

    public UnaryCallable<BulkMutation, Void> bulkMutationCallable() {
        return this.stub.bulkMutateRowsCallable();
    }

    public Boolean checkAndMutateRow(ConditionalRowMutation mutation) {
        return (Boolean)ApiExceptions.callAndTranslateApiException(this.checkAndMutateRowAsync(mutation));
    }

    public ApiFuture<Boolean> checkAndMutateRowAsync(ConditionalRowMutation mutation) {
        return this.checkAndMutateRowCallable().futureCall((Object)mutation);
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.stub.checkAndMutateRowCallable();
    }

    public Row readModifyWriteRow(ReadModifyWriteRow mutation) {
        return (Row)ApiExceptions.callAndTranslateApiException(this.readModifyWriteRowAsync(mutation));
    }

    public ApiFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRow mutation) {
        return this.readModifyWriteRowCallable().futureCall((Object)mutation);
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.stub.readModifyWriteRowCallable();
    }

    @Override
    public void close() {
        this.stub.close();
    }
}

