/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Instance {
    @Nonnull
    private final com.google.bigtable.admin.v2.Instance proto;

    @InternalApi
    public static Instance fromProto(@Nonnull com.google.bigtable.admin.v2.Instance proto) {
        return new Instance(proto);
    }

    private Instance(@Nonnull com.google.bigtable.admin.v2.Instance proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Name must be set");
        this.proto = proto;
    }

    public String getId() {
        InstanceName fullName = (InstanceName)Verify.verifyNotNull((Object)InstanceName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getDisplayName() {
        return this.proto.getDisplayName();
    }

    public Type getType() {
        return Type.fromProto(this.proto.getType());
    }

    public Map<String, String> getLabels() {
        return this.proto.getLabelsMap();
    }

    public State getState() {
        return State.fromProto(this.proto.getState());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        return Objects.equal((Object)this.proto, (Object)instance.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }

    public static enum State {
        NOT_KNOWN(Instance.State.STATE_NOT_KNOWN),
        READY(Instance.State.READY),
        CREATING(Instance.State.CREATING),
        UNRECOGNIZED(Instance.State.UNRECOGNIZED);

        private final Instance.State proto;

        @InternalApi
        public static State fromProto(Instance.State proto) {
            Preconditions.checkNotNull((Object)proto);
            for (State state : State.values()) {
                if (!state.proto.equals((Object)proto)) continue;
                return state;
            }
            return UNRECOGNIZED;
        }

        private State(Instance.State proto) {
            this.proto = proto;
        }

        @InternalApi
        public Instance.State toProto() {
            return this.proto;
        }
    }

    public static enum Type {
        PRODUCTION(Instance.Type.PRODUCTION),
        DEVELOPMENT(Instance.Type.DEVELOPMENT),
        UNRECOGNIZED(Instance.Type.UNRECOGNIZED);

        private final Instance.Type proto;

        @InternalApi
        public static Type fromProto(Instance.Type proto) {
            Preconditions.checkNotNull((Object)proto);
            Preconditions.checkArgument((proto != Instance.Type.TYPE_UNSPECIFIED ? 1 : 0) != 0, (Object)"Server instance type must always be specified");
            for (Type type : Type.values()) {
                if (!type.proto.equals((Object)proto)) continue;
                return type;
            }
            return UNRECOGNIZED;
        }

        private Type(Instance.Type proto) {
            this.proto = proto;
        }

        @InternalApi
        public Instance.Type toProto() {
            return this.proto;
        }
    }
}

