/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.model.GraphPresentation;
import org.apache.hop.neo4j.model.GraphProperty;

public class GraphNode {
    @HopMetadataProperty
    protected String name;
    @HopMetadataProperty
    protected String description;
    @HopMetadataProperty
    protected List<String> labels;
    @HopMetadataProperty
    protected List<GraphProperty> properties;
    @HopMetadataProperty
    protected GraphPresentation presentation;

    public GraphNode() {
        this.labels = new ArrayList<String>();
        this.properties = new ArrayList<GraphProperty>();
        this.presentation = new GraphPresentation(0, 0);
    }

    public GraphNode(String name, String description, List<String> labels, List<GraphProperty> properties) {
        this.name = name;
        this.description = description;
        this.labels = labels;
        this.properties = properties;
        this.presentation = new GraphPresentation(0, 0);
    }

    public GraphNode(GraphNode graphNode) {
        this();
        this.setName(graphNode.getName());
        this.setDescription(graphNode.getDescription());
        this.setLabels(new ArrayList<String>(graphNode.getLabels()));
        ArrayList<GraphProperty> propertiesCopy = new ArrayList<GraphProperty>();
        for (GraphProperty property : graphNode.getProperties()) {
            GraphProperty propertyCopy = new GraphProperty(property);
            propertiesCopy.add(propertyCopy);
        }
        this.setProperties(propertiesCopy);
        this.setPresentation(graphNode.getPresentation().clone());
    }

    public String toString() {
        return "GraphNode{name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof GraphNode)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return ((GraphNode)o).getName().equalsIgnoreCase(this.name);
    }

    public GraphProperty findProperty(String name) {
        for (GraphProperty property : this.properties) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public void validateIntegrity() throws HopException {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw new HopException("A node in a graph model needs to have a name");
        }
        if (this.labels == null || this.labels.isEmpty()) {
            throw new HopException("A graph node needs to have at least one label");
        }
        boolean hasPk = false;
        for (GraphProperty property : this.properties) {
            if (!property.isPrimary()) continue;
            hasPk = true;
            break;
        }
        if (!hasPk) {
            throw new HopException("Node '" + this.name + "' has no primary key field. This makes it impossible to update or create relationships with.");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public List<GraphProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GraphProperty> properties) {
        this.properties = properties;
    }

    public GraphPresentation getPresentation() {
        return this.presentation;
    }

    public void setPresentation(GraphPresentation presentation) {
        this.presentation = presentation;
    }
}

