/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collections;
import java.util.Set;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

public class NullSideInputReader
implements SideInputReader {
    private static final NullSideInputReader EMPTY_INSTANCE = NullSideInputReader.of(Collections.emptySet());
    private Set<PCollectionView<?>> views;

    public static NullSideInputReader empty() {
        return EMPTY_INSTANCE;
    }

    public static NullSideInputReader of(Iterable<? extends PCollectionView<?>> views) {
        return new NullSideInputReader(views);
    }

    private NullSideInputReader(Iterable<? extends PCollectionView<?>> views) {
        this.views = Sets.newHashSet(views);
    }

    @Override
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        throw new IllegalArgumentException("cannot call NullSideInputReader.get()");
    }

    @Override
    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    @Override
    public <T> boolean contains(PCollectionView<T> view) {
        return this.views.contains(view);
    }
}

