/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseWriteChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryImpl;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

public class TableDataWriteChannel
extends BaseWriteChannel<BigQueryOptions, WriteChannelConfiguration> {
    private Job job;

    TableDataWriteChannel(BigQueryOptions options, JobId jobId, WriteChannelConfiguration writeChannelConfiguration) {
        this(options, writeChannelConfiguration, TableDataWriteChannel.open(options, jobId, writeChannelConfiguration));
    }

    TableDataWriteChannel(BigQueryOptions options, WriteChannelConfiguration config, String uploadId) {
        super((ServiceOptions)options, (Serializable)config, uploadId);
    }

    protected void flushBuffer(final int length, final boolean last) {
        try {
            com.google.api.services.bigquery.model.Job jobPb = (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Job>(){

                @Override
                public com.google.api.services.bigquery.model.Job call() {
                    return ((BigQueryOptions)TableDataWriteChannel.this.getOptions()).getBigQueryRpcV2().write(TableDataWriteChannel.this.getUploadId(), TableDataWriteChannel.this.getBuffer(), 0, TableDataWriteChannel.this.getPosition(), length, last);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryImpl.EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            this.job = jobPb != null ? Job.fromPb((BigQuery)((BigQueryOptions)this.getOptions()).getService(), jobPb) : null;
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((BigQueryOptions)this.getOptions(), (WriteChannelConfiguration)this.getEntity(), this.getUploadId(), this.job);
    }

    private static String open(final BigQueryOptions options, final JobId jobId, final WriteChannelConfiguration writeChannelConfiguration) {
        try {
            return (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return options.getBigQueryRpcV2().open(new com.google.api.services.bigquery.model.Job().setConfiguration(writeChannelConfiguration.toPb()).setJobReference(jobId.toPb()));
                }
            }, (RetrySettings)options.getRetrySettings(), (ResultRetryAlgorithm)BigQueryImpl.EXCEPTION_HANDLER, (ApiClock)options.getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private void setJob(Job job) {
        this.job = job;
    }

    public Job getJob() {
        return this.job;
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<BigQueryOptions, WriteChannelConfiguration> {
        private static final long serialVersionUID = -2692851818766876346L;
        private final Job job;

        StateImpl(Builder builder) {
            super((BaseWriteChannel.BaseState.Builder)builder);
            this.job = builder.job;
        }

        static Builder builder(BigQueryOptions options, WriteChannelConfiguration config, String uploadId, Job job) {
            return new Builder(options, config, uploadId, job);
        }

        public WriteChannel restore() {
            TableDataWriteChannel channel = new TableDataWriteChannel((BigQueryOptions)this.serviceOptions, (WriteChannelConfiguration)this.entity, this.uploadId);
            channel.restore(this);
            channel.setJob(this.job);
            return channel;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.job);
        }

        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof StateImpl && Objects.equals(this.job, ((StateImpl)((Object)obj)).job);
        }

        protected List<BaseWriteChannel.BaseState.ValueHolder> toStringHelper() {
            List valueList = super.toStringHelper();
            valueList.add(BaseWriteChannel.BaseState.ValueHolder.create((String)"job", (Object)this.job));
            return valueList;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<BigQueryOptions, WriteChannelConfiguration> {
            private final Job job;

            private Builder(BigQueryOptions options, WriteChannelConfiguration configuration, String uploadId, Job job) {
                super((ServiceOptions)options, (Serializable)configuration, uploadId);
                this.job = job;
            }

            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

