/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.bigquery.AutoValue_Labels;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
abstract class Labels
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Labels ZERO = Labels.of(Collections.emptyMap());

    Labels() {
    }

    @Nullable
    abstract Map<String, String> userMap();

    @Nullable
    @Memoized
    Map<String, String> toPb() {
        Map<String, String> userMap = this.userMap();
        if (userMap == null) {
            return (Map)Data.nullOf(HashMap.class);
        }
        if (userMap.isEmpty()) {
            return null;
        }
        HashMap<String, String> pbMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : userMap.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (val == null) {
                val = Data.NULL_STRING;
            }
            pbMap.put(key, val);
        }
        return Collections.unmodifiableMap(pbMap);
    }

    private static Labels of(Map<String, String> userMap) {
        Preconditions.checkArgument((userMap == null || !userMap.containsKey(null) ? 1 : 0) != 0, (Object)"null keys are not supported");
        return new AutoValue_Labels(userMap);
    }

    static Labels fromUser(Map<String, String> map) {
        if (map == null || map instanceof ImmutableMap) {
            return Labels.of(map);
        }
        return Labels.of(Collections.unmodifiableMap(new HashMap<String, String>(map)));
    }

    static Labels fromPb(Map<String, String> pb) {
        if (Data.isNull(pb)) {
            return Labels.of(null);
        }
        if (pb == null || pb.isEmpty()) {
            return Labels.of(Collections.emptyMap());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : pb.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (Data.isNull((Object)val)) {
                val = null;
            }
            map.put(key, val);
        }
        return Labels.of(Collections.unmodifiableMap(map));
    }
}

