/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.UnboundedSource;

class SyntheticRecordsCheckpoint
implements UnboundedSource.CheckpointMark {
    private static final Coder<Long> LONG_CODER = BigEndianLongCoder.of();
    public static final Coder<SyntheticRecordsCheckpoint> CODER = new AtomicCoder<SyntheticRecordsCheckpoint>(){

        public void encode(SyntheticRecordsCheckpoint value, OutputStream outStream) throws IOException {
            LONG_CODER.encode((Object)value.currentCheckMarkPosition, outStream);
        }

        public SyntheticRecordsCheckpoint decode(InputStream inStream) throws IOException {
            long currentCheckMarkPosition = (Long)LONG_CODER.decode(inStream);
            return new SyntheticRecordsCheckpoint(currentCheckMarkPosition);
        }
    };
    private final long currentCheckMarkPosition;

    public SyntheticRecordsCheckpoint(long startPosition) {
        this.currentCheckMarkPosition = startPosition;
    }

    public void finalizeCheckpoint() {
    }

    public long getCurrentCheckMarkPosition() {
        return this.currentCheckMarkPosition;
    }
}

