/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

public class TimestampUtils {
    private static final BigDecimal MIN_SECONDS = BigDecimal.valueOf(Timestamp.MIN_VALUE.getSeconds());
    private static final int NANOS_PER_SECOND = (int)TimeUnit.SECONDS.toNanos(1L);

    public static BigDecimal toNanos(Timestamp timestamp) {
        BigDecimal secondsAsNanos = BigDecimal.valueOf(timestamp.getSeconds()).subtract(MIN_SECONDS).scaleByPowerOfTen(9);
        BigDecimal nanos = BigDecimal.valueOf(timestamp.getNanos());
        return secondsAsNanos.add(nanos);
    }

    public static Timestamp toTimestamp(BigDecimal bigDecimal) {
        BigDecimal nanos = bigDecimal.remainder(BigDecimal.ONE.scaleByPowerOfTen(9));
        BigDecimal seconds = bigDecimal.subtract(nanos).scaleByPowerOfTen(-9).add(MIN_SECONDS);
        return Timestamp.ofTimeSecondsAndNanos((long)seconds.longValue(), (int)nanos.intValue());
    }

    public static Timestamp next(Timestamp timestamp) {
        if (timestamp.equals((Object)Timestamp.MAX_VALUE)) {
            return timestamp;
        }
        int nanos = timestamp.getNanos();
        long seconds = timestamp.getSeconds();
        if (nanos + 1 >= NANOS_PER_SECOND) {
            return Timestamp.ofTimeSecondsAndNanos((long)(seconds + 1L), (int)0);
        }
        return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)(nanos + 1));
    }

    public static Timestamp previous(Timestamp timestamp) {
        if (timestamp.equals((Object)Timestamp.MIN_VALUE)) {
            return timestamp;
        }
        int nanos = timestamp.getNanos();
        long seconds = timestamp.getSeconds();
        if (nanos - 1 >= 0) {
            return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)(nanos - 1));
        }
        return Timestamp.ofTimeSecondsAndNanos((long)(seconds - 1L), (int)(NANOS_PER_SECOND - 1));
    }
}

