/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerServerPublisherCache;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PublisherAssembler;
import org.apache.beam.sdk.transforms.DoFn;

public class PubsubLiteSink
extends DoFn<PubSubMessage, Void> {
    private final PublisherOptions options;
    @GuardedBy(value="this")
    private transient RunState runState;

    public PubsubLiteSink(PublisherOptions options) {
        this.options = options;
    }

    @DoFn.StartBundle
    public synchronized void startBundle() throws ApiException {
        this.runState = new RunState(this.options);
    }

    @DoFn.ProcessElement
    public synchronized void processElement(@DoFn.Element PubSubMessage message) throws CheckedApiException {
        this.runState.publish(message);
    }

    @DoFn.FinishBundle
    public synchronized void finishBundle() throws Exception {
        this.runState.waitForDone();
    }

    private static class RunState {
        private final Deque<ApiFuture<MessageMetadata>> futures = new ArrayDeque<ApiFuture<MessageMetadata>>();
        private final Publisher<MessageMetadata> publisher;

        RunState(PublisherOptions options) {
            this.publisher = PerServerPublisherCache.PUBLISHER_CACHE.get(options, () -> new PublisherAssembler(options).newPublisher());
        }

        void publish(PubSubMessage message) {
            this.futures.add((ApiFuture<MessageMetadata>)this.publisher.publish(Message.fromProto((PubSubMessage)message)));
        }

        void waitForDone() throws Exception {
            ApiFutures.allAsList(this.futures).get(1L, TimeUnit.MINUTES);
        }
    }
}

