/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.Serializable;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;

public class ProtoFromBytes<T extends Message>
extends PTransform<PCollection<byte[]>, PCollection<T>> {
    private final ProtoParser<T> parser;

    ProtoFromBytes(ProtoParser<T> parser) {
        this.parser = parser;
    }

    public PCollection<T> expand(PCollection<byte[]> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<byte[], T>(){

            public T apply(byte[] bytes) {
                try {
                    return (Message)ProtoFromBytes.this.parser.parse(bytes);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    static interface ProtoParser<T2>
    extends Serializable {
        public T2 parse(byte[] var1) throws InvalidProtocolBufferException;
    }
}

