/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class IntervalWindow
extends BoundedWindow
implements Comparable<IntervalWindow> {
    private final Instant start;
    private final Instant end;

    public IntervalWindow(Instant start, Instant end) {
        this.start = start;
        this.end = end;
    }

    public IntervalWindow(Instant start, ReadableDuration size) {
        this.start = start;
        this.end = start.plus(size);
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    @Override
    public Instant maxTimestamp() {
        return this.end.minus((ReadableDuration)Duration.millis((long)1L));
    }

    public boolean contains(IntervalWindow other) {
        return !this.start.isAfter((ReadableInstant)other.start) && !this.end.isBefore((ReadableInstant)other.end);
    }

    public boolean isDisjoint(IntervalWindow other) {
        return !this.end.isAfter((ReadableInstant)other.start) || !other.end.isAfter((ReadableInstant)this.start);
    }

    public boolean intersects(IntervalWindow other) {
        return !this.isDisjoint(other);
    }

    public IntervalWindow span(IntervalWindow other) {
        return new IntervalWindow(new Instant(Math.min(this.start.getMillis(), other.start.getMillis())), new Instant(Math.max(this.end.getMillis(), other.end.getMillis())));
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof IntervalWindow && ((IntervalWindow)o).end.isEqual((ReadableInstant)this.end) && ((IntervalWindow)o).start.isEqual((ReadableInstant)this.start);
    }

    public int hashCode() {
        return (int)(this.start.getMillis() + (long)this.modInverse((int)(this.end.getMillis() << 1) + 1));
    }

    private int modInverse(int x) {
        int inverse = x * x * x;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        return inverse;
    }

    public String toString() {
        return "[" + this.start + ".." + this.end + ")";
    }

    @Override
    public int compareTo(IntervalWindow o) {
        if (this.start.isEqual((ReadableInstant)o.start)) {
            return this.end.compareTo((ReadableInstant)o.end);
        }
        return this.start.compareTo((ReadableInstant)o.start);
    }

    public static Coder<IntervalWindow> getCoder() {
        return IntervalWindowCoder.of();
    }

    public static class IntervalWindowCoder
    extends StructuredCoder<IntervalWindow> {
        private static final IntervalWindowCoder INSTANCE = new IntervalWindowCoder();
        private static final Coder<Instant> instantCoder = InstantCoder.of();
        private static final Coder<ReadableDuration> durationCoder = DurationCoder.of();

        public static IntervalWindowCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(IntervalWindow window, OutputStream outStream) throws IOException, CoderException {
            instantCoder.encode(window.end, outStream);
            durationCoder.encode((ReadableDuration)new Duration((ReadableInstant)window.start, (ReadableInstant)window.end), outStream);
        }

        @Override
        public IntervalWindow decode(InputStream inStream) throws IOException, CoderException {
            Instant end = instantCoder.decode(inStream);
            ReadableDuration duration = durationCoder.decode(inStream);
            return new IntervalWindow(end.minus(duration), end);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            instantCoder.verifyDeterministic();
            durationCoder.verifyDeterministic();
        }

        @Override
        public boolean consistentWithEquals() {
            return instantCoder.consistentWithEquals() && durationCoder.consistentWithEquals();
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(IntervalWindow value) {
            return instantCoder.isRegisterByteSizeObserverCheap(value.end) && durationCoder.isRegisterByteSizeObserverCheap((ReadableDuration)new Duration((ReadableInstant)value.start, (ReadableInstant)value.end));
        }

        @Override
        public void registerByteSizeObserver(IntervalWindow value, ElementByteSizeObserver observer) throws Exception {
            instantCoder.registerByteSizeObserver(value.end, observer);
            durationCoder.registerByteSizeObserver((ReadableDuration)new Duration((ReadableInstant)value.start, (ReadableInstant)value.end), observer);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }
    }
}

