/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.FieldTypeDescriptors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.transforms.AutoValue_SchemaAggregateFn_Inner;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFns;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
class SchemaAggregateFn {
    SchemaAggregateFn() {
    }

    static Inner create() {
        return new AutoValue_SchemaAggregateFn_Inner.Builder().setFieldAggregations(Lists.newArrayList()).build();
    }

    @AutoValue
    static abstract class Inner
    extends Combine.CombineFn<Row, Object[], Row> {
        Inner() {
        }

        abstract Builder toBuilder();

        abstract @Nullable Schema getInputSchema();

        abstract @Nullable Schema getOutputSchema();

        abstract @Nullable CombineFns.ComposedCombineFn getComposedCombineFn();

        abstract List<FieldAggregation> getFieldAggregations();

        Inner withSchema(Schema inputSchema) {
            List<FieldAggregation> fieldAggregations = this.getFieldAggregations().stream().map(f -> f.resolve(inputSchema)).collect(Collectors.toList());
            CombineFns.ComposedCombineFn<Row> composedCombineFn = null;
            for (int i = 0; i < fieldAggregations.size(); ++i) {
                Coder extractOutputCoder;
                SimpleFunction extractFunction;
                FieldAggregation fieldAggregation = (FieldAggregation)fieldAggregations.get(i);
                if (fieldAggregation.fieldsToAggregate.referencesSingleField()) {
                    extractFunction = new ExtractSingleFieldFunction(inputSchema, fieldAggregation.aggregateBaseValues, fieldAggregation);
                    Schema.FieldType fieldType = fieldAggregation.flattenedInputSubSchema.getField(0).getType();
                    if (fieldAggregation.aggregateBaseValues) {
                        while (fieldType.getTypeName().isLogicalType()) {
                            fieldType = fieldType.getLogicalType().getBaseType();
                        }
                    }
                    extractOutputCoder = SchemaCoder.coderForFieldType(fieldType);
                } else {
                    extractFunction = new ExtractFieldsFunction(inputSchema, fieldAggregation);
                    extractOutputCoder = SchemaCoder.of(fieldAggregation.inputSubSchema);
                }
                composedCombineFn = i == 0 ? CombineFns.compose().with(extractFunction, extractOutputCoder, fieldAggregation.fn, fieldAggregation.combineTag) : composedCombineFn.with(extractFunction, extractOutputCoder, fieldAggregation.fn, fieldAggregation.combineTag);
            }
            return this.toBuilder().setInputSchema(inputSchema).setComposedCombineFn(composedCombineFn).setFieldAggregations(fieldAggregations).build();
        }

        <CombineInputT, AccumT, CombineOutputT> Inner aggregateFields(FieldAccessDescriptor fieldsToAggregate, boolean aggregateBaseValues, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(fieldsToAggregate, aggregateBaseValues, fn, Schema.Field.of(outputFieldName, FieldTypeDescriptors.fieldTypeForJavaType(fn.getOutputType())));
        }

        <CombineInputT, AccumT, CombineOutputT> Inner aggregateFields(FieldAccessDescriptor fieldsToAggregate, boolean aggregateBaseValues, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            List<FieldAggregation> fieldAggregations = this.getFieldAggregations();
            TupleTag<Object> combineTag = new TupleTag<Object>(Integer.toString(fieldAggregations.size()));
            FieldAggregation<CombineInputT, AccumT, CombineOutputT> fieldAggregation = new FieldAggregation<CombineInputT, AccumT, CombineOutputT>(fieldsToAggregate, aggregateBaseValues, outputField, fn, combineTag);
            fieldAggregations.add(fieldAggregation);
            return this.toBuilder().setOutputSchema(this.getOutputSchema(fieldAggregations)).setFieldAggregations(fieldAggregations).build();
        }

        private Schema getOutputSchema(List<FieldAggregation> fieldAggregations) {
            Schema.Builder outputSchema = Schema.builder();
            for (FieldAggregation aggregation : fieldAggregations) {
                outputSchema.addField(aggregation.outputField);
            }
            return outputSchema.build();
        }

        @Override
        public Object[] createAccumulator() {
            return this.getComposedCombineFn().createAccumulator();
        }

        @Override
        public Object[] addInput(Object[] accumulator, Row input) {
            return this.getComposedCombineFn().addInput(accumulator, input);
        }

        @Override
        public Object[] mergeAccumulators(Iterable<Object[]> accumulator) {
            return this.getComposedCombineFn().mergeAccumulators(accumulator);
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<Row> inputCoder) throws CannotProvideCoderException {
            return this.getComposedCombineFn().getAccumulatorCoder(registry, inputCoder);
        }

        @Override
        public Coder<Row> getDefaultOutputCoder(CoderRegistry registry, Coder<Row> inputCoder) {
            return SchemaCoder.of(this.getOutputSchema());
        }

        @Override
        public Row extractOutput(Object[] accumulator) {
            CombineFns.CoCombineResult coCombineResult = this.getComposedCombineFn().extractOutput(accumulator);
            Row.Builder output = Row.withSchema(this.getOutputSchema());
            for (FieldAggregation fieldAggregation : this.getFieldAggregations()) {
                Object aggregate = coCombineResult.get(fieldAggregation.combineTag);
                output.addValue(aggregate);
            }
            return output.build();
        }

        private static class ExtractFieldsFunction
        extends SimpleFunction<Row, Row> {
            private final RowSelector rowSelector;

            private ExtractFieldsFunction(Schema inputSchema, FieldAggregation fieldAggregation) {
                this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, fieldAggregation.fieldsToAggregate, true);
            }

            @Override
            public Row apply(Row row) {
                return this.rowSelector.select(row);
            }
        }

        private static class ExtractSingleFieldFunction<OutputT>
        extends SimpleFunction<Row, OutputT> {
            private final RowSelector rowSelector;
            private final boolean extractBaseValue;
            private final @Nullable RowSelector flatteningSelector;
            private final FieldAggregation fieldAggregation;

            private ExtractSingleFieldFunction(Schema inputSchema, boolean extractBaseValue, FieldAggregation fieldAggregation) {
                this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, fieldAggregation.fieldsToAggregate, true);
                this.extractBaseValue = extractBaseValue;
                this.flatteningSelector = fieldAggregation.needsFlattening ? new SelectHelpers.RowSelectorContainer(fieldAggregation.inputSubSchema, fieldAggregation.flattenedFieldAccessDescriptor, true) : null;
                this.fieldAggregation = fieldAggregation;
            }

            @Override
            public OutputT apply(Row row) {
                Row selected = this.rowSelector.select(row);
                if (this.fieldAggregation.needsFlattening) {
                    selected = this.flatteningSelector.select(selected);
                }
                if (this.extractBaseValue && selected.getSchema().getField(0).getType().getTypeName().isLogicalType()) {
                    return (OutputT)selected.getBaseValue(0, Object.class);
                }
                return (OutputT)selected.getValue(0);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setInputSchema(@Nullable Schema var1);

            abstract Builder setOutputSchema(@Nullable Schema var1);

            abstract Builder setComposedCombineFn(@Nullable CombineFns.ComposedCombineFn var1);

            abstract Builder setFieldAggregations(List<FieldAggregation> var1);

            abstract Inner build();
        }

        static class FieldAggregation<FieldT, AccumT, OutputT>
        implements Serializable {
            FieldAccessDescriptor fieldsToAggregate;
            private final boolean aggregateBaseValues;
            private final Schema.Field outputField;
            private final Combine.CombineFn<FieldT, AccumT, OutputT> fn;
            private final TupleTag<Object> combineTag;
            private final @Nullable Schema inputSubSchema;
            private final @Nullable FieldAccessDescriptor flattenedFieldAccessDescriptor;
            private final @Nullable Schema flattenedInputSubSchema;
            private final Schema aggregationSchema;
            private final boolean needsFlattening;

            FieldAggregation(FieldAccessDescriptor fieldsToAggregate, boolean aggregateBaseValues, Schema.Field outputField, Combine.CombineFn<FieldT, AccumT, OutputT> fn, TupleTag<Object> combineTag) {
                this(fieldsToAggregate, aggregateBaseValues, outputField, fn, combineTag, Schema.builder().addField(outputField).build(), null);
            }

            FieldAggregation(FieldAccessDescriptor fieldsToAggregate, boolean aggregateBaseValues, Schema.Field outputField, Combine.CombineFn<FieldT, AccumT, OutputT> fn, TupleTag<Object> combineTag, Schema aggregationSchema, @Nullable Schema inputSchema) {
                this.aggregateBaseValues = aggregateBaseValues;
                if (inputSchema != null) {
                    this.fieldsToAggregate = fieldsToAggregate.resolve(inputSchema);
                    if (aggregateBaseValues) {
                        Preconditions.checkArgument((boolean)fieldsToAggregate.referencesSingleField());
                    }
                    this.inputSubSchema = SelectHelpers.getOutputSchema(inputSchema, this.fieldsToAggregate);
                    this.flattenedFieldAccessDescriptor = SelectHelpers.allLeavesDescriptor(this.inputSubSchema, SelectHelpers.CONCAT_FIELD_NAMES);
                    this.flattenedInputSubSchema = SelectHelpers.getOutputSchema(this.inputSubSchema, this.flattenedFieldAccessDescriptor);
                    this.needsFlattening = !inputSchema.equals(this.flattenedInputSubSchema);
                } else {
                    this.fieldsToAggregate = fieldsToAggregate;
                    this.inputSubSchema = null;
                    this.flattenedFieldAccessDescriptor = null;
                    this.flattenedInputSubSchema = null;
                    this.needsFlattening = false;
                }
                this.outputField = outputField;
                this.fn = fn;
                this.combineTag = combineTag;
                this.aggregationSchema = aggregationSchema;
            }

            FieldAggregation<FieldT, AccumT, OutputT> resolve(Schema schema) {
                return new FieldAggregation<FieldT, AccumT, OutputT>(this.fieldsToAggregate, this.aggregateBaseValues, this.outputField, this.fn, this.combineTag, this.aggregationSchema, schema);
            }
        }
    }
}

