/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;

public class BigEndianIntegerCoder
extends AtomicCoder<Integer> {
    private static final BigEndianIntegerCoder INSTANCE = new BigEndianIntegerCoder();
    private static final TypeDescriptor<Integer> TYPE_DESCRIPTOR = new TypeDescriptor<Integer>(){};

    public static BigEndianIntegerCoder of() {
        return INSTANCE;
    }

    private BigEndianIntegerCoder() {
    }

    @Override
    public void encode(Integer value, OutputStream outStream) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        BitConverters.writeBigEndianInt(value, outStream);
    }

    @Override
    public Integer decode(InputStream inStream) throws IOException, CoderException {
        try {
            return BitConverters.readBigEndianInt(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Integer value) {
        return true;
    }

    @Override
    public TypeDescriptor<Integer> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Integer value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        return 4L;
    }
}

