/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class ProjectionProducerVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private final Map<PCollection<?>, FieldAccessDescriptor> pCollectionFieldAccess;
    private final ImmutableMap.Builder<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> pushdownOpportunities = ImmutableMap.builder();

    ProjectionProducerVisitor(Map<PCollection<?>, FieldAccessDescriptor> pCollectionFieldAccess) {
        this.pCollectionFieldAccess = pCollectionFieldAccess;
    }

    Map<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> getPushdownOpportunities() {
        return this.pushdownOpportunities.build();
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        PTransform transform = node.getTransform();
        if (!node.getInputs().isEmpty()) {
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        if (!(transform instanceof ProjectionProducer)) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
        ProjectionProducer pushdownProjector = (ProjectionProducer)transform;
        if (!pushdownProjector.supportsProjectionPushdown()) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PCollection output : node.getOutputs().values()) {
            FieldAccessDescriptor fieldAccess = this.pCollectionFieldAccess.get(output);
            if (fieldAccess == null || fieldAccess.getAllFields()) continue;
            builder.put((Object)output, (Object)fieldAccess);
        }
        ImmutableMap localOpportunities = builder.build();
        if (localOpportunities.isEmpty()) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
        this.pushdownOpportunities.put((Object)pushdownProjector, (Object)localOpportunities);
        return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
    }
}

