/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.io.IOException;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkContextFactory;
import org.apache.beam.runners.spark.translation.TransformTranslator;
import org.apache.beam.runners.spark.translation.streaming.Checkpoint;
import org.apache.beam.runners.spark.translation.streaming.StreamingTransformTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function0;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRunnerStreamingContextFactory
implements Function0<JavaStreamingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRunnerStreamingContextFactory.class);
    private final transient Pipeline pipeline;
    private final transient SparkPipelineOptions options;
    private final transient Checkpoint.CheckpointDir checkpointDir;

    public SparkRunnerStreamingContextFactory(Pipeline pipeline, SparkPipelineOptions options, Checkpoint.CheckpointDir checkpointDir) {
        this.pipeline = pipeline;
        this.options = options;
        this.checkpointDir = checkpointDir;
    }

    public JavaStreamingContext call() throws Exception {
        LOG.info("Creating a new Spark Streaming Context");
        Preconditions.checkArgument((this.options.getMinReadTimeMillis() < this.options.getBatchIntervalMillis() ? 1 : 0) != 0, (Object)"Minimum read time has to be less than batch time.");
        Preconditions.checkArgument((this.options.getReadTimePercentage() > 0.0 && this.options.getReadTimePercentage() < 1.0 ? 1 : 0) != 0, (Object)"Read time percentage is bound to (0, 1).");
        StreamingTransformTranslator.Translator translator = new StreamingTransformTranslator.Translator(new TransformTranslator.Translator());
        Duration batchDuration = new Duration(this.options.getBatchIntervalMillis().longValue());
        LOG.info("Setting Spark streaming batchDuration to {} msec", (Object)batchDuration.milliseconds());
        JavaSparkContext sparkCtx = SparkContextFactory.getSparkContext(this.options);
        JavaStreamingContext streamingCtx = new JavaStreamingContext(sparkCtx, batchDuration);
        SparkRunner.initAccumulators(this.options, sparkCtx);
        EvaluationContext evalCtx = new EvaluationContext(sparkCtx, this.pipeline, this.options, streamingCtx);
        SparkRunner.updateCacheCandidates(this.pipeline, translator, evalCtx);
        try {
            this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)new SparkRunner.Evaluator(translator, evalCtx));
        }
        catch (RuntimeException e) {
            streamingCtx.stop(false, false);
            SparkContextFactory.stopSparkContext(sparkCtx);
            throw e;
        }
        evalCtx.computeOutputs();
        this.checkpoint(streamingCtx, this.checkpointDir);
        return streamingCtx;
    }

    private void checkpoint(JavaStreamingContext jssc, Checkpoint.CheckpointDir checkpointDir) {
        Path rootCheckpointPath = checkpointDir.getRootCheckpointDir();
        Path sparkCheckpointPath = checkpointDir.getSparkCheckpointDir();
        Path beamCheckpointPath = checkpointDir.getBeamCheckpointDir();
        try {
            FileSystem fileSystem = rootCheckpointPath.getFileSystem(jssc.sparkContext().hadoopConfiguration());
            if (!fileSystem.exists(rootCheckpointPath)) {
                fileSystem.mkdirs(rootCheckpointPath);
            }
            if (!fileSystem.exists(sparkCheckpointPath)) {
                fileSystem.mkdirs(sparkCheckpointPath);
            }
            if (!fileSystem.exists(beamCheckpointPath)) {
                fileSystem.mkdirs(beamCheckpointPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create checkpoint dir", e);
        }
        jssc.checkpoint(sparkCheckpointPath.toString());
    }
}

