/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.translation.SparkContextFactory;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.joda.time.Duration;

public abstract class SparkPipelineResult
implements PipelineResult {
    final Future pipelineExecution;
    final JavaSparkContext javaSparkContext;
    PipelineResult.State state;

    SparkPipelineResult(Future<?> pipelineExecution, JavaSparkContext javaSparkContext) {
        this.pipelineExecution = pipelineExecution;
        this.javaSparkContext = javaSparkContext;
        this.state = PipelineResult.State.RUNNING;
    }

    private static RuntimeException runtimeExceptionFrom(Throwable e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static RuntimeException beamExceptionFrom(Throwable e) {
        if (e instanceof SparkException) {
            if (e.getCause() != null && e.getCause() instanceof UserCodeException) {
                UserCodeException userException = (UserCodeException)e.getCause();
                return new Pipeline.PipelineExecutionException(userException.getCause());
            }
            if (e.getCause() != null) {
                return new Pipeline.PipelineExecutionException(e.getCause());
            }
        }
        return SparkPipelineResult.runtimeExceptionFrom(e);
    }

    protected abstract void stop();

    protected abstract PipelineResult.State awaitTermination(Duration var1) throws TimeoutException, ExecutionException, InterruptedException;

    public PipelineResult.State getState() {
        return this.state;
    }

    public PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)-1L));
    }

    public PipelineResult.State waitUntilFinish(Duration duration) {
        try {
            PipelineResult.State finishState = this.awaitTermination(duration);
            this.offerNewState(finishState);
        }
        catch (TimeoutException finishState) {
        }
        catch (ExecutionException e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkPipelineResult.beamExceptionFrom(e.getCause());
        }
        catch (Exception e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkPipelineResult.beamExceptionFrom(e);
        }
        return this.state;
    }

    public MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)MetricsAccumulator.getInstance().value());
    }

    public PipelineResult.State cancel() throws IOException {
        this.offerNewState(PipelineResult.State.CANCELLED);
        return this.state;
    }

    private void offerNewState(PipelineResult.State newState) {
        PipelineResult.State oldState = this.state;
        this.state = newState;
        if (!oldState.isTerminal() && newState.isTerminal()) {
            this.stop();
        }
    }

    static class PortableStreamingMode
    extends StreamingMode
    implements PortablePipelineResult {
        PortableStreamingMode(Future<?> pipelineExecution, JavaStreamingContext javaStreamingContext) {
            super(pipelineExecution, javaStreamingContext);
        }

        public JobApi.MetricResults portableMetrics() {
            return JobApi.MetricResults.newBuilder().addAllAttempted(MetricsAccumulator.getInstance().value().getMonitoringInfos()).build();
        }
    }

    static class StreamingMode
    extends SparkPipelineResult {
        private final JavaStreamingContext javaStreamingContext;

        StreamingMode(Future<?> pipelineExecution, JavaStreamingContext javaStreamingContext) {
            super(pipelineExecution, javaStreamingContext.sparkContext());
            this.javaStreamingContext = javaStreamingContext;
        }

        @Override
        protected void stop() {
            this.javaStreamingContext.stop(false, true);
            try {
                this.javaStreamingContext.awaitTerminationOrTimeout(0L);
            }
            catch (Exception e) {
                throw SparkPipelineResult.beamExceptionFrom(e);
            }
            finally {
                SparkContextFactory.stopSparkContext(this.javaSparkContext);
                if (Objects.equals(this.state, PipelineResult.State.RUNNING)) {
                    this.state = PipelineResult.State.STOPPED;
                }
            }
        }

        @Override
        protected PipelineResult.State awaitTermination(Duration duration) throws ExecutionException, InterruptedException {
            PipelineResult.State terminationState;
            this.pipelineExecution.get();
            this.javaStreamingContext.awaitTerminationOrTimeout(duration.getMillis());
            switch (this.javaStreamingContext.getState()) {
                case ACTIVE: {
                    terminationState = PipelineResult.State.RUNNING;
                    break;
                }
                case STOPPED: {
                    terminationState = PipelineResult.State.DONE;
                    break;
                }
                default: {
                    terminationState = PipelineResult.State.UNKNOWN;
                }
            }
            return terminationState;
        }
    }

    static class PortableBatchMode
    extends BatchMode
    implements PortablePipelineResult {
        PortableBatchMode(Future<?> pipelineExecution, JavaSparkContext javaSparkContext) {
            super(pipelineExecution, javaSparkContext);
        }

        public JobApi.MetricResults portableMetrics() {
            return JobApi.MetricResults.newBuilder().addAllAttempted(MetricsAccumulator.getInstance().value().getMonitoringInfos()).build();
        }
    }

    static class BatchMode
    extends SparkPipelineResult {
        BatchMode(Future<?> pipelineExecution, JavaSparkContext javaSparkContext) {
            super(pipelineExecution, javaSparkContext);
        }

        @Override
        protected void stop() {
            SparkContextFactory.stopSparkContext(this.javaSparkContext);
            if (Objects.equals(this.state, PipelineResult.State.RUNNING)) {
                this.state = PipelineResult.State.STOPPED;
            }
        }

        @Override
        protected PipelineResult.State awaitTermination(Duration duration) throws TimeoutException, ExecutionException, InterruptedException {
            if (duration.getMillis() > 0L) {
                this.pipelineExecution.get(duration.getMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.pipelineExecution.get();
            }
            return PipelineResult.State.DONE;
        }
    }
}

