/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.util.TimeZone;
import ru.yandex.clickhouse.domain.ClickHouseDataType;

public final class ClickHouseColumnInfo {
    private static final String KEYWORD_NULLABLE = "Nullable";
    private static final String KEYWORD_LOW_CARDINALITY = "LowCardinality";
    private static final String KEYWORD_ARRAY = "Array";
    private ClickHouseDataType clickHouseDataType;
    private final String originalTypeName;
    private final String columnName;
    private boolean nullable;
    private boolean lowCardinality;
    private int arrayLevel;
    private ClickHouseDataType arrayBaseType;
    private TimeZone timeZone;
    private int precision;
    private int scale;
    private ClickHouseColumnInfo keyInfo;
    private ClickHouseColumnInfo valueInfo;
    private String functionName;

    @Deprecated
    public static ClickHouseColumnInfo parse(String typeInfo, String columnName) {
        return ClickHouseColumnInfo.parse(typeInfo, columnName, null);
    }

    public static ClickHouseColumnInfo parse(String typeInfo, String columnName, TimeZone serverTimeZone) {
        int endIdx;
        ClickHouseColumnInfo column = new ClickHouseColumnInfo(typeInfo, columnName);
        int currIdx = 0;
        while (typeInfo.startsWith(KEYWORD_ARRAY, currIdx)) {
            ++column.arrayLevel;
            column.clickHouseDataType = ClickHouseDataType.Array;
            currIdx += KEYWORD_ARRAY.length() + 1;
        }
        if (typeInfo.startsWith(KEYWORD_LOW_CARDINALITY, currIdx)) {
            column.lowCardinality = true;
            currIdx += KEYWORD_LOW_CARDINALITY.length() + 1;
        }
        if (typeInfo.startsWith(KEYWORD_NULLABLE, currIdx)) {
            column.nullable = true;
            currIdx += KEYWORD_NULLABLE.length() + 1;
        }
        int n = endIdx = typeInfo.indexOf("(", currIdx) < 0 ? typeInfo.indexOf(")", currIdx) : typeInfo.indexOf("(", currIdx);
        if (endIdx < 0) {
            endIdx = typeInfo.length();
        }
        ClickHouseDataType dataType = ClickHouseDataType.fromTypeString(typeInfo.substring(currIdx, endIdx));
        if (column.arrayLevel > 0) {
            column.arrayBaseType = dataType;
        } else {
            column.clickHouseDataType = dataType;
        }
        column.precision = dataType.getDefaultPrecision();
        column.scale = dataType.getDefaultScale();
        column.timeZone = serverTimeZone;
        currIdx = endIdx;
        if (endIdx == typeInfo.length() || !typeInfo.startsWith("(", currIdx)) {
            return column;
        }
        switch (dataType) {
            case AggregateFunction: {
                String[] argsAf = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                column.functionName = argsAf[0];
                column.arrayBaseType = ClickHouseDataType.Unknown;
                if (argsAf.length != 2) break;
                column.arrayBaseType = ClickHouseDataType.fromTypeString(argsAf[1]);
                break;
            }
            case DateTime: {
                TimeZone tz;
                String[] argsDt = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsDt.length == 2) {
                    column.scale = Integer.parseInt(argsDt[0]);
                    column.timeZone = TimeZone.getTimeZone(argsDt[1].replace("'", ""));
                    break;
                }
                if (argsDt.length != 1) break;
                column.timeZone = tz = TimeZone.getTimeZone(argsDt[0].replace("'", ""));
                break;
            }
            case DateTime32: {
                TimeZone tz;
                String[] argsD32 = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsD32.length != 1) break;
                column.timeZone = tz = TimeZone.getTimeZone(argsD32[0].replace("'", ""));
                break;
            }
            case DateTime64: {
                String[] argsD64 = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsD64.length != 2) break;
                column.scale = Integer.parseInt(argsD64[0]);
                column.timeZone = TimeZone.getTimeZone(argsD64[1].replace("'", ""));
                break;
            }
            case Decimal: {
                String[] argsDecimal = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsDecimal.length != 2) break;
                column.precision = Integer.parseInt(argsDecimal[0]);
                column.scale = Integer.parseInt(argsDecimal[1]);
                break;
            }
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                String[] argsScale = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                column.scale = Integer.parseInt(argsScale[0]);
                break;
            }
            case FixedString: {
                String[] argsPrecision = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                column.precision = Integer.parseInt(argsPrecision[0]);
                break;
            }
            case Map: {
                String[] argsMap = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsMap.length != 2) break;
                column.keyInfo = ClickHouseColumnInfo.parse(argsMap[0], columnName + "Key", serverTimeZone);
                column.valueInfo = ClickHouseColumnInfo.parse(argsMap[1], columnName + "Value", serverTimeZone);
                break;
            }
        }
        return column;
    }

    private static String[] splitArgs(String args, int currIdx) {
        return args.substring(args.indexOf("(", currIdx) + 1, args.indexOf(")", currIdx)).split("\\s*,\\s*");
    }

    private ClickHouseColumnInfo(String originalTypeName, String columnName) {
        this.originalTypeName = originalTypeName;
        this.columnName = columnName;
    }

    public ClickHouseDataType getClickHouseDataType() {
        return this.clickHouseDataType;
    }

    public String getOriginalTypeName() {
        return this.originalTypeName;
    }

    public String getCleanTypeName() {
        int start;
        if (!this.nullable && !this.lowCardinality) {
            return this.originalTypeName;
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        int numParens = 0;
        if (this.lowCardinality) {
            start = this.originalTypeName.indexOf(KEYWORD_LOW_CARDINALITY);
            sb.append(this.originalTypeName.substring(idx, start));
            ++numParens;
            idx = start + KEYWORD_LOW_CARDINALITY.length() + 1;
        }
        if (this.nullable) {
            start = this.originalTypeName.indexOf(KEYWORD_NULLABLE, idx);
            sb.append(this.originalTypeName.substring(idx, start));
            ++numParens;
            idx = start + KEYWORD_NULLABLE.length() + 1;
        }
        sb.append(this.originalTypeName.substring(idx, this.originalTypeName.length() - numParens));
        return sb.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    boolean isLowCardinality() {
        return this.lowCardinality;
    }

    public int getArrayLevel() {
        return this.arrayLevel;
    }

    public boolean isArray() {
        return this.arrayLevel > 0;
    }

    public ClickHouseDataType getArrayBaseType() {
        return this.arrayBaseType;
    }

    public ClickHouseDataType getEffectiveClickHouseDataType() {
        return this.arrayLevel > 0 ? this.arrayBaseType : this.clickHouseDataType;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public ClickHouseColumnInfo getKeyInfo() {
        return this.keyInfo;
    }

    public ClickHouseColumnInfo getValueInfo() {
        return this.valueInfo;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

