/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.internal;

import com.clickhouse.client.internal.google.common.annotations.VisibleForTesting;
import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.google.common.util.concurrent.ListenableFuture;
import com.clickhouse.client.internal.google.common.util.concurrent.SettableFuture;
import com.clickhouse.client.internal.grpc.CallOptions;
import com.clickhouse.client.internal.grpc.ClientStreamTracer;
import com.clickhouse.client.internal.grpc.InternalChannelz;
import com.clickhouse.client.internal.grpc.InternalLogId;
import com.clickhouse.client.internal.grpc.Metadata;
import com.clickhouse.client.internal.grpc.MethodDescriptor;
import com.clickhouse.client.internal.grpc.Status;
import com.clickhouse.client.internal.grpc.internal.ClientStream;
import com.clickhouse.client.internal.grpc.internal.ClientStreamListener;
import com.clickhouse.client.internal.grpc.internal.ClientTransport;
import com.clickhouse.client.internal.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

