/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.grpc.ClickHouseGrpcChannelFactory;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.client.internal.grpc.ManagedChannelBuilder;
import com.clickhouse.client.internal.grpc.okhttp.OkHttpChannelBuilder;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

final class OkHttpChannelFactoryImpl
extends ClickHouseGrpcChannelFactory {
    private final OkHttpChannelBuilder builder;

    OkHttpChannelFactoryImpl(ClickHouseConfig config, ClickHouseNode server) {
        super(config, server);
        this.builder = OkHttpChannelBuilder.forAddress(server.getHost(), server.getPort());
        int flowControlWindow = (Integer)config.getOption(ClickHouseGrpcOption.FLOW_CONTROL_WINDOW);
        if (flowControlWindow > 0) {
            this.builder.flowControlWindow(flowControlWindow);
        }
    }

    @Override
    protected ManagedChannelBuilder<?> getChannelBuilder() {
        return this.builder;
    }

    @Override
    protected void setupSsl() {
        if (!this.config.isSsl()) {
            this.builder.usePlaintext();
        } else {
            try {
                this.builder.useTransportSecurity().sslSocketFactory(ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).get().getSocketFactory());
            }
            catch (SSLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected void setupTimeout() {
    }
}

