/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.reflection.StringSearchResult;
import org.apache.hop.core.reflection.StringSearcher;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.SearchResult;

public abstract class BaseSearchableAnalyser<T> {
    protected void matchProperty(ISearchable<T> parent, List<ISearchResult> searchResults, ISearchQuery searchQuery, String propertyName, String propertyValue, String component) {
        if (searchQuery.matches(propertyName)) {
            searchResults.add((ISearchResult)new SearchResult(parent, propertyName, "matching property name: " + propertyName, component, propertyValue));
        }
        if (StringUtils.isNotEmpty((String)propertyValue) && searchQuery.matches(propertyValue)) {
            searchResults.add((ISearchResult)new SearchResult(parent, propertyValue, "matching property value: " + propertyValue, component, propertyValue));
        }
    }

    protected void matchObjectFields(ISearchable<T> searchable, List<ISearchResult> searchResults, ISearchQuery searchQuery, Object object, String descriptionPrefix, String component) {
        ArrayList<StringSearchResult> stringSearchResults = new ArrayList<StringSearchResult>();
        StringSearcher.findMetaData(object, 1, stringSearchResults, searchable.getSearchableObject(), searchable);
        for (StringSearchResult stringSearchResult : stringSearchResults) {
            if (searchQuery.matches(stringSearchResult.getFieldName())) {
                searchResults.add((ISearchResult)new SearchResult(searchable, stringSearchResult.getFieldName(), descriptionPrefix + " : " + stringSearchResult.getFieldName(), component, stringSearchResult.getString()));
            }
            if (!searchQuery.matches(stringSearchResult.getString())) continue;
            searchResults.add((ISearchResult)new SearchResult(searchable, stringSearchResult.getString(), descriptionPrefix + " : " + stringSearchResult.getFieldName(), component, stringSearchResult.getString()));
        }
    }
}

