/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.oraclerdb;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="ORACLERDB", typeDescription="Oracle RDB", documentationUrl="/database/databases/oraclerdb.html")
@GuiPlugin(id="GUI-OracleRDBDatabaseMeta")
public class OracleRDBDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " WHERE 1=0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " WHERE 1=0";
    }

    public String getDriverClass() {
        return "oracle.rdb.jdbc.rdbThin.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) throws HopDatabaseException {
        return "jdbc:rdbThin://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isSupportsOptionsInURL() {
        return false;
    }

    public boolean isSupportsSequences() {
        return true;
    }

    public String getSqlListOfSequences() {
        return "SELECT SEQUENCE_NAME FROM USER_SEQUENCES";
    }

    public String getSqlSequenceExists(String sequenceName) {
        return "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM dual";
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public boolean isSupportsSynonyms() {
        return true;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD ( " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY (" + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false) + " )";
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        StringBuilder retval = new StringBuilder(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval.append("DATE");
                break;
            }
            case 4: {
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval.append("NUMBER");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval.append("CLOB");
                    break;
                }
                if (length > 0 && length <= 2000) {
                    retval.append("VARCHAR2(").append(length).append(')');
                    break;
                }
                if (length <= 0) {
                    retval.append("VARCHAR2(2000)");
                    break;
                }
                retval.append("CLOB");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (addCr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    public String getSqlLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(Const.CR);
        }
        return sql.toString();
    }

    public String getSqlUnlockTables(String[] tableNames) {
        return null;
    }

    public String getStartQuote() {
        return "";
    }

    public String getEndQuote() {
        return "";
    }
}

