/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.resourcemanager.AbstractResourceManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.LogListInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class TaskManagerLogListHandler
extends AbstractResourceManagerHandler<RestfulGateway, EmptyRequestBody, LogListInfo, TaskManagerMessageParameters> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public TaskManagerLogListHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, LogListInfo, TaskManagerMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.resourceManagerGatewayRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<LogListInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ResourceID taskManagerId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        ResourceManagerGateway resourceManagerGateway = TaskManagerLogListHandler.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        CompletableFuture<Collection<LogInfo>> logsWithLengthFuture = resourceManagerGateway.requestTaskManagerLogList(taskManagerId, this.timeout);
        return ((CompletableFuture)logsWithLengthFuture.thenApply(LogListInfo::new)).exceptionally(throwable -> {
            Throwable strippedThrowable = ExceptionUtils.stripCompletionException((Throwable)throwable);
            if (strippedThrowable instanceof UnknownTaskExecutorException) {
                throw new CompletionException((Throwable)((Object)new RestHandlerException("Could not find TaskExecutor " + taskManagerId, HttpResponseStatus.NOT_FOUND, strippedThrowable)));
            }
            throw new CompletionException((Throwable)throwable);
        });
    }
}

