/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.dh;

import com.trilead.ssh2.crypto.dh.Curve25519Exchange;
import com.trilead.ssh2.crypto.dh.DhExchange;
import com.trilead.ssh2.crypto.dh.EcDhExchange;
import com.trilead.ssh2.crypto.digest.HashForSSH2Types;
import com.trilead.ssh2.log.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public abstract class GenericDhExchange {
    private static final Logger log = Logger.getLogger(GenericDhExchange.class);
    BigInteger sharedSecret;

    protected GenericDhExchange() {
    }

    public static GenericDhExchange getInstance(String algo) {
        if ("curve25519-sha256".equals(algo) || "curve25519-sha256@libssh.org".equals(algo)) {
            return new Curve25519Exchange();
        }
        if (algo.startsWith("ecdh-sha2-")) {
            return new EcDhExchange();
        }
        return new DhExchange();
    }

    public abstract void init(String var1) throws IOException;

    public abstract byte[] getE();

    protected abstract byte[] getServerE();

    public BigInteger getK() {
        if (this.sharedSecret == null) {
            throw new IllegalStateException("Shared secret not yet known, need f first!");
        }
        return this.sharedSecret;
    }

    public abstract void setF(byte[] var1) throws IOException;

    public byte[] calculateH(byte[] clientversion, byte[] serverversion, byte[] clientKexPayload, byte[] serverKexPayload, byte[] hostKey) throws UnsupportedEncodingException {
        HashForSSH2Types hash = new HashForSSH2Types(this.getHashAlgo());
        if (log.isEnabled()) {
            log.log(90, "Client: '" + new String(clientversion) + "'");
            log.log(90, "Server: '" + new String(serverversion) + "'");
        }
        hash.updateByteString(clientversion);
        hash.updateByteString(serverversion);
        hash.updateByteString(clientKexPayload);
        hash.updateByteString(serverKexPayload);
        hash.updateByteString(hostKey);
        hash.updateByteString(this.getE());
        hash.updateByteString(this.getServerE());
        hash.updateBigInt(this.sharedSecret);
        return hash.getDigest();
    }

    public abstract String getHashAlgo();
}

