/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.stats;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.internal.Provider;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.stats.NoopStats;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.stats.StatsCollectionState;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.stats.StatsComponent;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.stats.StatsRecorder;
import org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.stats.ViewManager;

public final class Stats {
    private static final Logger logger = Logger.getLogger(Stats.class.getName());
    private static final StatsComponent statsComponent = Stats.loadStatsComponent(StatsComponent.class.getClassLoader());

    public static StatsRecorder getStatsRecorder() {
        return statsComponent.getStatsRecorder();
    }

    public static ViewManager getViewManager() {
        return statsComponent.getViewManager();
    }

    public static StatsCollectionState getState() {
        return statsComponent.getState();
    }

    @Deprecated
    public static void setState(StatsCollectionState state) {
        statsComponent.setState(state);
    }

    static StatsComponent loadStatsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.impl.stats.StatsComponentImpl", true, classLoader), StatsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for StatsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("org.apache.beam.vendor.grpc.v1p48p1.io.opencensus.impllite.stats.StatsComponentImplLite", true, classLoader), StatsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for StatsComponent, now using default implementation for StatsComponent.", e2);
                return NoopStats.newNoopStatsComponent();
            }
        }
    }

    private Stats() {
    }
}

