/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_CLUSTER_BACKUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String cluster;
    private final String backup;

    @Deprecated
    protected BackupName() {
        this.project = null;
        this.instance = null;
        this.cluster = null;
        this.backup = null;
    }

    private BackupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.backup = (String)Preconditions.checkNotNull((Object)builder.getBackup());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getBackup() {
        return this.backup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupName of(String project, String instance, String cluster, String backup) {
        return BackupName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).setBackup(backup).build();
    }

    public static String format(String project, String instance, String cluster, String backup) {
        return BackupName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).setBackup(backup).build().toString();
    }

    public static BackupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_CLUSTER_BACKUP.validatedMatch(formattedString, "BackupName.parse: formattedString not in valid format");
        return BackupName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("cluster"), (String)matchMap.get("backup"));
    }

    public static List<BackupName> parseList(List<String> formattedStrings) {
        ArrayList<BackupName> list = new ArrayList<BackupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_CLUSTER_BACKUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupName backupName = this;
            synchronized (backupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.backup != null) {
                        fieldMapBuilder.put((Object)"backup", (Object)this.backup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_CLUSTER_BACKUP.instantiate(new String[]{"project", this.project, "instance", this.instance, "cluster", this.cluster, "backup", this.backup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BackupName that = (BackupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.backup, that.backup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backup);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String cluster;
        private String backup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getBackup() {
            return this.backup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setBackup(String backup) {
            this.backup = backup;
            return this;
        }

        private Builder(BackupName backupName) {
            this.project = backupName.project;
            this.instance = backupName.instance;
            this.cluster = backupName.cluster;
            this.backup = backupName.backup;
        }

        public BackupName build() {
            return new BackupName(this);
        }
    }
}

