/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GcsResourceId
implements ResourceId {
    private final GcsPath gcsPath;

    static GcsResourceId fromGcsPath(GcsPath gcsPath) {
        Preconditions.checkNotNull((Object)gcsPath, (Object)"gcsPath");
        return new GcsResourceId(gcsPath);
    }

    private GcsResourceId(GcsPath gcsPath) {
        this.gcsPath = gcsPath;
    }

    public GcsResourceId resolve(String other, ResolveOptions resolveOptions) {
        Preconditions.checkState((boolean)this.isDirectory(), (Object)String.format("Expected the gcsPath is a directory, but had [%s].", this.gcsPath));
        Preconditions.checkArgument((resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE) || resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) ? 1 : 0) != 0, (Object)String.format("ResolveOptions: [%s] is not supported.", resolveOptions));
        if (resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE)) {
            Preconditions.checkArgument((!other.endsWith("/") ? 1 : 0) != 0, (String)"The resolved file: [%s] should not end with '/'.", (Object)other);
            return GcsResourceId.fromGcsPath(this.gcsPath.resolve(other));
        }
        if (other.endsWith("/")) {
            return GcsResourceId.fromGcsPath(this.gcsPath.resolve(other));
        }
        return GcsResourceId.fromGcsPath(this.gcsPath.resolve(other + "/"));
    }

    public GcsResourceId getCurrentDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        GcsPath parent = this.gcsPath.getParent();
        Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)String.format("Failed to get the current directory for path: [%s].", this.gcsPath));
        return GcsResourceId.fromGcsPath(parent);
    }

    public boolean isDirectory() {
        return this.gcsPath.endsWith("/");
    }

    public String getScheme() {
        return "gs";
    }

    public @Nullable String getFilename() {
        if (this.gcsPath.getNameCount() <= 1) {
            return null;
        }
        GcsPath gcsFilename = this.gcsPath.getFileName();
        return gcsFilename == null ? null : gcsFilename.toString();
    }

    GcsPath getGcsPath() {
        return this.gcsPath;
    }

    public String toString() {
        return this.gcsPath.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof GcsResourceId)) {
            return false;
        }
        GcsResourceId other = (GcsResourceId)obj;
        return this.gcsPath.equals(other.gcsPath);
    }

    public int hashCode() {
        return this.gcsPath.hashCode();
    }
}

