/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Resource;
import java.util.Hashtable;

class ResourcePool {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int TRACE_INCREMENT_ = 100;
    private transient Hashtable resources_ = new Hashtable();
    private transient Hashtable referenceCounts_ = new Hashtable();
    public static final ResourcePool GLOBAL_RESOURCE_POOL = new ResourcePool();

    ResourcePool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            this.resources_.clear();
            this.referenceCounts_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        Object object = resource.getResourceKey();
        long l = -1L;
        boolean bl = false;
        Hashtable hashtable = this.resources_;
        synchronized (hashtable) {
            if (this.resources_.containsKey(object)) {
                bl = true;
                long[] lArray = (long[])this.referenceCounts_.get(object);
                lArray[0] = lArray[0] - 1L;
                l = lArray[0];
                if (l == 0L) {
                    int n;
                    this.resources_.remove(object);
                    this.referenceCounts_.remove(object);
                    if (Trace.isTraceOn() && (n = this.resources_.size()) % 100 == 0) {
                        Trace.log(3, "Resource pool " + this + " contains " + n + " resources.");
                    }
                }
            }
        }
    }

    public Resource getResource(Object object) {
        if (object == null) {
            throw new NullPointerException("resourceKey");
        }
        return (Resource)this.resources_.get(object);
    }

    public void register(Resource resource) {
        this.register(resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Resource resource, boolean bl) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        Object object = resource.getResourceKey();
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            if (this.resources_.containsKey(object)) {
                if (bl) {
                    this.resources_.put(object, resource);
                }
                long[] lArray = (long[])this.referenceCounts_.get(object);
                long l = lArray[0] + 1L;
                lArray[0] = l;
                long l2 = l;
            } else {
                int n;
                this.resources_.put(object, resource);
                this.referenceCounts_.put(object, new long[]{1L});
                long l = 1L;
                if (Trace.isTraceOn() && (n = this.resources_.size()) % 100 == 0) {
                    Trace.log(3, "Resource pool " + this + " contains " + n + " resources.");
                }
            }
        }
    }
}

