/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSConfig;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.PSServerSocketContainerAdapter;
import com.ibm.as400.access.ProxyServer;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxConfigReqSV;
import com.ibm.as400.access.PxConnectReqSV;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxEndReqSV;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxLoadReqSV;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

class PSController
extends StoppableThread {
    private static long nextConnectionId_ = 1000L;
    private static Object nextConnectionIdLock_ = new Object();
    private boolean closed_ = false;
    private Socket connectedSocket_;
    private long connectionId_ = -1L;
    private PxDSFactory factory_;
    private InputStream input_;
    private boolean ownSocket_ = false;
    private OutputStream output_;
    private boolean running_ = false;
    private PSServerSocketContainerAdapter serverSocket_;

    public PSController(Vector vector, ProxyServer proxyServer, PSLoad pSLoad, PSLoadBalancer pSLoadBalancer, PSConfig pSConfig, PSServerSocketContainerAdapter pSServerSocketContainerAdapter) {
        super("PSController-" + pSServerSocketContainerAdapter);
        this.serverSocket_ = pSServerSocketContainerAdapter;
        this.factory_ = new PxDSFactory();
        this.factory_.register(new PxBooleanParm());
        this.factory_.register(new PxIntParm());
        this.factory_.register(new PxStringParm());
        this.factory_.register(new PxSerializedObjectParm(null));
        this.factory_.register(new PxConnectReqSV(vector, this, pSLoad, pSLoadBalancer));
        this.factory_.register(new PxConfigReqSV(pSConfig, this));
        this.factory_.register(new PxEndReqSV(proxyServer, this));
        this.factory_.register(new PxLoadReqSV(pSLoad));
        if (Trace.isTraceOn()) {
            Trace.log(6, "Px server controller " + this + " opened.");
        }
    }

    public void closeServerSocket() {
        if (Trace.isTraceOn()) {
            Trace.log(6, "Px server controller " + this + " closed.");
        }
        this.closeSocket();
        try {
            this.serverSocket_.close();
        }
        catch (IOException iOException) {
            Trace.log(2, iOException.getMessage(), (Throwable)iOException);
        }
        this.closed_ = true;
    }

    public void closeSocket() {
        if (this.ownSocket_) {
            try {
                if (this.connectedSocket_ != null) {
                    this.connectedSocket_.close();
                }
            }
            catch (IOException iOException) {
                Trace.log(2, "Exception closing proxy socket:", (Throwable)iOException);
            }
            this.ownSocket_ = false;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.closeServerSocket();
        }
        super.finalize();
    }

    public InetAddress getClientAddress() {
        return this.connectedSocket_.getInetAddress();
    }

    public Socket getConnectedSocket() {
        this.ownSocket_ = false;
        return this.connectedSocket_;
    }

    public long getConnectionId() {
        return this.connectionId_;
    }

    public InputStream getInputStream() {
        return this.input_;
    }

    public OutputStream getOutputStream() {
        return this.output_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running_ = true;
        while (this.canContinue()) {
            try {
                this.connectedSocket_ = this.serverSocket_.accept();
            }
            catch (Exception exception) {
                Verbose.println(exception);
                Trace.log(2, "Exception accepting proxy socket:", (Throwable)exception);
                break;
            }
            try {
                PxRepSV pxRepSV;
                this.input_ = new BufferedInputStream(this.connectedSocket_.getInputStream());
                this.output_ = new BufferedOutputStream(this.connectedSocket_.getOutputStream());
                this.ownSocket_ = true;
                Object object = nextConnectionIdLock_;
                synchronized (object) {
                    this.connectionId_ = ++nextConnectionId_;
                }
                object = (PxReqSV)this.factory_.getNextDS(this.input_);
                if (Trace.isTraceProxyOn()) {
                    ((PxReqSV)object).dump(Trace.getPrintWriter());
                }
                if ((pxRepSV = ((PxReqSV)object).process()) == null) continue;
                pxRepSV.setCorrelationId(((PxReqSV)object).getCorrelationId());
                OutputStream outputStream = this.output_;
                synchronized (outputStream) {
                    if (Trace.isTraceProxyOn()) {
                        pxRepSV.dump(Trace.getPrintWriter());
                    }
                    pxRepSV.writeTo(this.output_);
                    this.output_.flush();
                }
            }
            catch (Exception exception) {
                Verbose.println(exception);
                Trace.log(2, "Exception processing proxy request:", (Throwable)exception);
            }
            finally {
                this.closeSocket();
            }
        }
        this.running_ = false;
    }

    public void stopSafely() {
        super.stopSafely();
        this.closeServerSocket();
        try {
            while (this.running_) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_ENDED", this.serverSocket_));
    }

    public String toString() {
        return this.serverSocket_.toString();
    }
}

