/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class NPSystem
implements Runnable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int CONVERSATION_TIMEOUT = 300000;
    private static Hashtable NPSystemTable_ = new Hashtable();
    private AS400ImplRemote as400System_;
    private Vector availConversations_;
    private Vector inuseConversations_;
    private Vector deadConversations_;
    private Thread cleanupThread_;

    private NPSystem(AS400ImplRemote aS400ImplRemote) {
        this.as400System_ = aS400ImplRemote;
        this.availConversations_ = new Vector();
        this.inuseConversations_ = new Vector();
        this.deadConversations_ = new Vector();
    }

    static NPSystem getSystem(AS400ImplRemote aS400ImplRemote) {
        NPSystem nPSystem = null;
        nPSystem = (NPSystem)NPSystemTable_.get(aS400ImplRemote);
        if (nPSystem == null) {
            nPSystem = new NPSystem(aS400ImplRemote);
            NPSystemTable_.put(aS400ImplRemote, nPSystem);
        }
        return nPSystem;
    }

    synchronized NPConversation getConversation() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPConversation nPConversation = null;
        do {
            if (this.availConversations_.isEmpty()) {
                if (!this.deadConversations_.isEmpty()) {
                    nPConversation = (NPConversation)this.deadConversations_.firstElement();
                    this.deadConversations_.removeElement(nPConversation);
                } else {
                    AS400Server aS400Server;
                    if (this.inuseConversations_.isEmpty()) {
                        aS400Server = this.as400System_.getConnection(1, false, false);
                    } else {
                        aS400Server = this.as400System_.getConnection(1, true, false);
                        if (this.as400System_.isThreadUsed()) {
                            this.startCleanupThread();
                        }
                    }
                    nPConversation = new NPConversation(this.as400System_, aS400Server);
                }
            } else {
                nPConversation = (NPConversation)this.availConversations_.firstElement();
                this.availConversations_.removeElement(nPConversation);
            }
            if (nPConversation.getServer().isConnected()) continue;
            Trace.log(1, "Conversation was not connected.");
            this.as400System_.disconnectServer(nPConversation.getServer());
        } while (!nPConversation.getServer().isConnected());
        this.inuseConversations_.addElement(nPConversation);
        return nPConversation;
    }

    synchronized void returnConversation(NPConversation nPConversation) {
        int n = this.inuseConversations_.indexOf(nPConversation);
        if (n != -1) {
            this.inuseConversations_.removeElementAt(n);
            if (nPConversation.getServer().isConnected()) {
                if (this.as400System_.isThreadUsed()) {
                    this.availConversations_.addElement(nPConversation);
                } else if (this.availConversations_.size() < 1) {
                    this.availConversations_.addElement(nPConversation);
                } else {
                    this.as400System_.disconnectServer(nPConversation.getServer());
                }
            }
        }
    }

    int makeRequest(NPDataStream nPDataStream, NPDataStream nPDataStream2) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        int n;
        NPConversation nPConversation = this.getConversation();
        try {
            n = nPConversation.makeRequest(nPDataStream, nPDataStream2);
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            throw new ErrorCompletingRequestException(1);
        }
        finally {
            this.returnConversation(nPConversation);
        }
        return n;
    }

    private synchronized boolean cleanUpDeadConversations() {
        int n = this.deadConversations_.size() - 1;
        int n2 = this.inuseConversations_.size() + this.availConversations_.size();
        if (n2 > 0) {
            ++n;
        }
        Enumeration enumeration = this.deadConversations_.elements();
        for (int i = 0; i < n; ++i) {
            NPConversation nPConversation = (NPConversation)enumeration.nextElement();
            if (nPConversation == null) continue;
            this.as400System_.disconnectServer(nPConversation.getServer());
        }
        if (enumeration.hasMoreElements()) {
            this.availConversations_.addElement((NPConversation)enumeration.nextElement());
        }
        this.deadConversations_ = this.availConversations_;
        this.availConversations_ = new Vector();
        return n2 > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            boolean bl;
            do {
                Thread.sleep(300000L);
            } while (bl = this.cleanUpDeadConversations());
        }
        catch (InterruptedException interruptedException) {}
    }

    synchronized void startCleanupThread() {
        if (this.cleanupThread_ == null) {
            this.cleanupThread_ = new Thread(this);
            this.cleanupThread_.setDaemon(true);
            this.cleanupThread_.start();
        }
    }

    synchronized void stopCleanupThread() {
        if (this.cleanupThread_ != null) {
            this.cleanupThread_.stop();
            this.cleanupThread_ = null;
        }
    }
}

