/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class CollectionSerializer<T>
extends TypeSerializer<T> {
    protected abstract List<ByteBuffer> serializeValues(T var1);

    protected abstract int getElementCount(T var1);

    public abstract <V> T deserializeForNativeProtocol(V var1, ValueAccessor<V> var2, ProtocolVersion var3);

    public T deserializeForNativeProtocol(ByteBuffer value, ProtocolVersion version) {
        return this.deserializeForNativeProtocol(value, ByteBufferAccessor.instance, version);
    }

    public abstract <V> void validateForNativeProtocol(V var1, ValueAccessor<V> var2, ProtocolVersion var3);

    @Override
    public ByteBuffer serialize(T input) {
        List<ByteBuffer> values = this.serializeValues(input);
        return CollectionSerializer.pack(values, ByteBufferAccessor.instance, this.getElementCount(input), ProtocolVersion.V3);
    }

    @Override
    public <V> T deserialize(V value, ValueAccessor<V> accessor) {
        return this.deserializeForNativeProtocol(value, accessor, ProtocolVersion.V3);
    }

    @Override
    public <T1> void validate(T1 value, ValueAccessor<T1> accessor) throws MarshalException {
        this.validateForNativeProtocol(value, accessor, ProtocolVersion.V3);
    }

    public static ByteBuffer pack(Collection<ByteBuffer> values, int elements, ProtocolVersion version) {
        return CollectionSerializer.pack(values, ByteBufferAccessor.instance, elements, version);
    }

    public static <V> V pack(Collection<V> values, ValueAccessor<V> accessor, int elements, ProtocolVersion version) {
        int size = 0;
        for (V value : values) {
            size += CollectionSerializer.sizeOfValue(value, accessor, version);
        }
        ByteBuffer result = ByteBuffer.allocate(CollectionSerializer.sizeOfCollectionSize(elements, version) + size);
        CollectionSerializer.writeCollectionSize(result, elements, version);
        for (V value : values) {
            CollectionSerializer.writeValue(result, value, accessor, version);
        }
        return accessor.valueOf((ByteBuffer)result.flip());
    }

    protected static void writeCollectionSize(ByteBuffer output, int elements, ProtocolVersion version) {
        output.putInt(elements);
    }

    public static int readCollectionSize(ByteBuffer input, ProtocolVersion version) {
        return CollectionSerializer.readCollectionSize(input, ByteBufferAccessor.instance, version);
    }

    public static <V> int readCollectionSize(V value, ValueAccessor<V> accessor, ProtocolVersion version) {
        return accessor.toInt(value);
    }

    public static int sizeOfCollectionSize(int elements, ProtocolVersion version) {
        return 4;
    }

    public static <V> void writeValue(ByteBuffer output, V value, ValueAccessor<V> accessor, ProtocolVersion version) {
        if (value == null) {
            output.putInt(-1);
            return;
        }
        output.putInt(accessor.size(value));
        accessor.write(value, output);
    }

    public static <V> V readValue(V input, ValueAccessor<V> accessor, int offset, ProtocolVersion version) {
        int size = accessor.getInt(input, offset);
        if (size < 0) {
            return null;
        }
        return accessor.slice(input, offset + 4, size);
    }

    protected static void skipValue(ByteBuffer input, ProtocolVersion version) {
        int size = input.getInt();
        input.position(input.position() + size);
    }

    public static <V> int skipValue(V input, ValueAccessor<V> accessor, int offset, ProtocolVersion version) {
        int size = accessor.getInt(input, offset);
        return TypeSizes.sizeof(size) + size;
    }

    public static <V> int sizeOfValue(V value, ValueAccessor<V> accessor, ProtocolVersion version) {
        return value == null ? 4 : 4 + accessor.size(value);
    }

    public abstract ByteBuffer getSerializedValue(ByteBuffer var1, ByteBuffer var2, AbstractType<?> var3);

    public abstract ByteBuffer getSliceFromSerialized(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, AbstractType<?> var4, boolean var5);

    protected ByteBuffer copyAsNewCollection(ByteBuffer input, int count, int startPos, int endPos, ProtocolVersion version) {
        int sizeLen = CollectionSerializer.sizeOfCollectionSize(count, version);
        if (count == 0) {
            return ByteBuffer.allocate(sizeLen);
        }
        int bodyLen = endPos - startPos;
        ByteBuffer output = ByteBuffer.allocate(sizeLen + bodyLen);
        CollectionSerializer.writeCollectionSize(output, count, version);
        output.position(0);
        ByteBufferUtil.copyBytes(input, startPos, output, sizeLen, bodyLen);
        return output;
    }
}

