/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelineTranslationModeOptimizer
extends FlinkPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineTranslationModeOptimizer.class);
    private boolean hasUnboundedCollections;

    static boolean hasUnboundedOutput(Pipeline p) {
        PipelineTranslationModeOptimizer optimizer = new PipelineTranslationModeOptimizer();
        optimizer.translate(p);
        return optimizer.hasUnboundedCollections;
    }

    private PipelineTranslationModeOptimizer() {
    }

    @Override
    public void translate(Pipeline pipeline) {
        super.translate(pipeline);
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        AppliedPTransform appliedPTransform = node.toAppliedPTransform(this.getPipeline());
        if (this.hasUnboundedOutput(appliedPTransform)) {
            Class<?> transformClass = node.getTransform().getClass();
            LOG.debug("Found unbounded PCollection for transform {}", transformClass);
            this.hasUnboundedCollections = true;
        }
    }

    private boolean hasUnboundedOutput(AppliedPTransform<?, ?, ?> transform) {
        return transform.getOutputs().values().stream().filter(value -> value instanceof PCollection).map(value -> value).anyMatch(collection -> collection.isBounded() == PCollection.IsBounded.UNBOUNDED);
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
    }
}

