/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.admin.v2.BigtableTableAdminGrpc;
import com.google.bigtable.v2.BigtableGrpc;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.List;

@InternalExtensionOnly
public final class TracingUtilities {
    public static void setupTracingConfig() {
        ArrayList<String> descriptors = new ArrayList<String>();
        TracingUtilities.addDescriptor(descriptors, BigtableTableAdminGrpc.getServiceDescriptor());
        TracingUtilities.addDescriptor(descriptors, BigtableGrpc.getServiceDescriptor());
        Tracing.getExportComponent().getSampledSpanStore().registerSpanNamesForCollection(descriptors);
    }

    private static void addDescriptor(List<String> descriptors, ServiceDescriptor serviceDescriptor) {
        for (MethodDescriptor method : serviceDescriptor.getMethods()) {
            descriptors.add("Operation." + method.getFullMethodName().replace('/', '.'));
        }
    }

    private TracingUtilities() {
    }
}

