/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.bigtable.config.CredentialFactory;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;

@InternalApi(value="For internal use only")
public class DirectPathUtil {
    private static final Logger LOG = new Logger(DirectPathUtil.class);
    private static final String GCE_PRODUCTION_NAME_PRIOR_2016 = "Google";
    private static final String GCE_PRODUCTION_NAME_AFTER_2016 = "Google Compute Engine";
    private static final Supplier<Boolean> isOnComputeEngine = Suppliers.memoize((Supplier)new Supplier<Boolean>(){

        public Boolean get() {
            String osName = System.getProperty("os.name");
            if ("Linux".equals(osName)) {
                try {
                    String result = Files.asCharSource((File)new File("/sys/class/dmi/id/product_name"), (Charset)StandardCharsets.UTF_8).readFirstLine();
                    return result != null && (result.contains(DirectPathUtil.GCE_PRODUCTION_NAME_PRIOR_2016) || result.contains(DirectPathUtil.GCE_PRODUCTION_NAME_AFTER_2016));
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    });

    private DirectPathUtil() {
    }

    public static boolean shouldAttemptDirectPath(String endpoint, int port, CredentialOptions creds) {
        return (Boolean)isOnComputeEngine.get() != false && DirectPathUtil.areCredsDirectPathCompatible(creds);
    }

    private static boolean areCredsDirectPathCompatible(CredentialOptions credentialOptions) {
        if (credentialOptions.getCredentialType() != CredentialOptions.CredentialType.DefaultCredentials) {
            return false;
        }
        Credentials credentials = null;
        try {
            credentials = CredentialFactory.getCredentials(credentialOptions);
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.warn("Failed to probe credentials, assuming they are not DirectPath compatible", e, new Object[0]);
        }
        return credentials instanceof ComputeEngineCredentials;
    }
}

