/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractMultiUseTransaction;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ChecksumResultSet;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.FailedBatchUpdate;
import com.google.cloud.spanner.connection.FailedQuery;
import com.google.cloud.spanner.connection.FailedUpdate;
import com.google.cloud.spanner.connection.RetriableBatchUpdate;
import com.google.cloud.spanner.connection.RetriableUpdate;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.SpannerGrpc;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReadWriteTransaction
extends AbstractMultiUseTransaction {
    private static final Logger logger = Logger.getLogger(ReadWriteTransaction.class.getName());
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private static final String MAX_INTERNAL_RETRIES_EXCEEDED = "Internal transaction retry maximum exceeded";
    private static final int MAX_INTERNAL_RETRIES = 50;
    private final long transactionId;
    private final DatabaseClient dbClient;
    private final TransactionManager txManager;
    private final boolean retryAbortsInternally;
    private int transactionRetryAttempts;
    private int successfulRetries;
    private final List<TransactionRetryListener> transactionRetryListeners;
    private volatile ApiFuture<TransactionContext> txContextFuture;
    private volatile SettableApiFuture<CommitResponse> commitResponseFuture;
    private volatile UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private volatile AbortedException abortedException;
    private boolean timedOutOrCancelled = false;
    private final List<RetriableStatement> statements = new ArrayList<RetriableStatement>();
    private final List<Mutation> mutations = new ArrayList<Mutation>();
    private Timestamp transactionStarted;
    final Object abortedLock = new Object();
    private final Callable<Void> commitCallable = new Callable<Void>(){

        @Override
        public Void call() {
            ReadWriteTransaction.this.checkAborted();
            ((TransactionContext)SpannerApiFutures.get(ReadWriteTransaction.this.txContextFuture)).buffer(ReadWriteTransaction.this.mutations);
            ReadWriteTransaction.this.txManager.commit();
            ReadWriteTransaction.this.commitResponseFuture.set((Object)ReadWriteTransaction.this.txManager.getCommitResponse());
            ReadWriteTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
            return null;
        }
    };
    private final Callable<Void> rollbackCallable = new Callable<Void>(){

        @Override
        public Void call() {
            try {
                if (ReadWriteTransaction.this.state != UnitOfWork.UnitOfWorkState.ABORTED) {
                    SpannerApiFutures.get(ReadWriteTransaction.this.txContextFuture);
                    ReadWriteTransaction.this.txManager.rollback();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                ReadWriteTransaction.this.txManager.close();
            }
        }
    };

    static Builder newBuilder() {
        return new Builder();
    }

    private ReadWriteTransaction(Builder builder) {
        super(builder);
        this.transactionId = ID_GENERATOR.incrementAndGet();
        this.dbClient = builder.dbClient;
        this.retryAbortsInternally = builder.retryAbortsInternally;
        this.transactionRetryListeners = builder.transactionRetryListeners;
        this.txManager = this.dbClient.transactionManager(this.extractOptions(builder));
    }

    private Options.TransactionOption[] extractOptions(Builder builder) {
        int numOptions = 0;
        if (builder.returnCommitStats) {
            ++numOptions;
        }
        if (this.transactionTag != null) {
            ++numOptions;
        }
        if (this.rpcPriority != null) {
            ++numOptions;
        }
        Options.TransactionOption[] options = new Options.TransactionOption[numOptions];
        int index = 0;
        if (builder.returnCommitStats) {
            options[index++] = Options.commitStats();
        }
        if (this.transactionTag != null) {
            options[index++] = Options.tag(this.transactionTag);
        }
        if (this.rpcPriority != null) {
            options[index++] = Options.priority(this.rpcPriority);
        }
        return options;
    }

    public String toString() {
        return "ReadWriteTransaction - ID: " + this.transactionId + "; Tag: " + Strings.nullToEmpty((String)this.transactionTag) + "; Status: " + this.internalGetStateName() + "; Started: " + this.internalGetTimeStarted() + "; Retry attempts: " + this.transactionRetryAttempts + "; Successful retries: " + this.successfulRetries;
    }

    private String internalGetStateName() {
        return this.transactionStarted == null ? "Not yet started" : this.getState().toString();
    }

    private String internalGetTimeStarted() {
        return this.transactionStarted == null ? "Not yet started" : this.transactionStarted.toString();
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    void checkValidTransaction() {
        this.checkValidState();
        if (this.txContextFuture == null) {
            this.transactionStarted = Timestamp.now();
            this.txContextFuture = this.executeStatementAsync(AbstractStatementParser.BEGIN_STATEMENT, () -> this.txManager.begin(), SpannerGrpc.getBeginTransactionMethod());
        }
    }

    private void checkValidState() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED || this.state == UnitOfWork.UnitOfWorkState.ABORTED, "This transaction has status " + this.state.name() + ", only " + (Object)((Object)UnitOfWork.UnitOfWorkState.STARTED) + "or " + (Object)((Object)UnitOfWork.UnitOfWorkState.ABORTED) + " is allowed.");
        this.checkTimedOut();
    }

    private void checkTimedOut() {
        ConnectionPreconditions.checkState(!this.timedOutOrCancelled, "The last statement of this transaction timed out or was cancelled. The transaction is no longer usable. Rollback the transaction and start a new one.");
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive() || this.state == UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    void checkAborted() {
        if (this.state == UnitOfWork.UnitOfWorkState.ABORTED && this.abortedException != null) {
            if (this.abortedException instanceof AbortedDueToConcurrentModificationException) {
                throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException((AbortedDueToConcurrentModificationException)this.abortedException);
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "This transaction has already been aborted. Rollback this transaction to start a new one.", (Throwable)((Object)this.abortedException));
        }
    }

    @Override
    TransactionContext getReadContext() {
        ConnectionPreconditions.checkState(this.txContextFuture != null, "Missing transaction context");
        return SpannerApiFutures.get(this.txContextFuture);
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for read/write transactions.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    private boolean hasCommitResponse() {
        return this.commitResponseFuture != null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(this.hasCommitResponse(), "This transaction has not been committed.");
        return SpannerApiFutures.get(this.commitResponseFuture).getCommitTimestamp();
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return this.hasCommitResponse() ? SpannerApiFutures.get(this.commitResponseFuture).getCommitTimestamp() : null;
    }

    @Override
    public CommitResponse getCommitResponse() {
        ConnectionPreconditions.checkState(this.hasCommitResponse(), "This transaction has not been committed.");
        return SpannerApiFutures.get(this.commitResponseFuture);
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        return this.hasCommitResponse() ? SpannerApiFutures.get(this.commitResponseFuture) : null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(AbstractStatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DDL-statements are not allowed inside a read/write transaction.");
    }

    private void handlePossibleInvalidatingException(SpannerException e) {
        if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED || e.getErrorCode() == ErrorCode.CANCELLED) {
            this.timedOutOrCancelled = true;
        }
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
        this.checkValidTransaction();
        ApiFuture<ResultSet> res = this.retryAbortsInternally ? this.executeStatementAsync(statement, () -> {
            this.checkTimedOut();
            return this.runWithRetry(() -> {
                try {
                    this.getStatementExecutor().invokeInterceptors(statement, StatementExecutionStep.EXECUTE_STATEMENT, this);
                    DirectExecuteResultSet delegate = DirectExecuteResultSet.ofResultSet(this.internalExecuteQuery(statement, analyzeMode, options));
                    return this.createAndAddRetryResultSet(delegate, statement, analyzeMode, options);
                }
                catch (AbortedException e) {
                    throw e;
                }
                catch (SpannerException e) {
                    this.createAndAddFailedQuery(e, statement, analyzeMode, options);
                    throw e;
                }
            });
        }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteStreamingSqlMethod())) : super.executeQueryAsync(statement, analyzeMode, options);
        ApiFutures.addCallback(res, (ApiFutureCallback)new ApiFutureCallback<ResultSet>(){

            public void onFailure(Throwable t) {
                if (t instanceof SpannerException) {
                    ReadWriteTransaction.this.handlePossibleInvalidatingException((SpannerException)((Object)t));
                }
            }

            public void onSuccess(ResultSet result) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public ApiFuture<ResultSetStats> analyzeUpdateAsync(AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        return this.internalExecuteUpdateAsync(update, analyzeMode, options);
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        return ApiFutures.transform(this.internalExecuteUpdateAsync(update, AnalyzeMode.NONE, options), ResultSetStats::getRowCountExact, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<ResultSetStats> internalExecuteUpdateAsync(AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"The statement is not an update statement");
        this.checkValidTransaction();
        ApiFuture<ResultSetStats> res = this.retryAbortsInternally ? this.executeStatementAsync(update, () -> {
            this.checkTimedOut();
            return this.runWithRetry(() -> {
                try {
                    this.getStatementExecutor().invokeInterceptors(update, StatementExecutionStep.EXECUTE_STATEMENT, this);
                    ResultSetStats updateCount = analyzeMode == AnalyzeMode.NONE ? ResultSetStats.newBuilder().setRowCountExact(SpannerApiFutures.get(this.txContextFuture).executeUpdate(update.getStatement(), options)).build() : SpannerApiFutures.get(this.txContextFuture).analyzeUpdate(update.getStatement(), analyzeMode.getQueryAnalyzeMode(), options);
                    this.createAndAddRetriableUpdate(update, analyzeMode, updateCount.getRowCountExact(), options);
                    return updateCount;
                }
                catch (AbortedException e) {
                    throw e;
                }
                catch (SpannerException e) {
                    this.createAndAddFailedUpdate(e, update);
                    throw e;
                }
            });
        }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod())) : this.executeStatementAsync(update, () -> {
            this.checkTimedOut();
            this.checkAborted();
            if (analyzeMode == AnalyzeMode.NONE) {
                return ResultSetStats.newBuilder().setRowCountExact(SpannerApiFutures.get(this.txContextFuture).executeUpdate(update.getStatement(), options)).build();
            }
            return SpannerApiFutures.get(this.txContextFuture).analyzeUpdate(update.getStatement(), analyzeMode.getQueryAnalyzeMode(), options);
        }, SpannerGrpc.getExecuteSqlMethod());
        ApiFutures.addCallback(res, (ApiFutureCallback)new ApiFutureCallback<ResultSetStats>(){

            public void onFailure(Throwable t) {
                if (t instanceof SpannerException) {
                    ReadWriteTransaction.this.handlePossibleInvalidatingException((SpannerException)((Object)t));
                }
            }

            public void onSuccess(ResultSetStats result) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        Preconditions.checkNotNull(updates);
        LinkedList<Statement> updateStatements = new LinkedList<Statement>();
        for (AbstractStatementParser.ParsedStatement update : updates) {
            Preconditions.checkArgument((boolean)update.isUpdate(), (Object)("Statement is not an update statement: " + update.getSqlWithoutComments()));
            updateStatements.add(update.getStatement());
        }
        this.checkValidTransaction();
        ApiFuture<long[]> res = this.retryAbortsInternally ? this.executeStatementAsync(AbstractStatementParser.RUN_BATCH_STATEMENT, () -> {
            this.checkTimedOut();
            return this.runWithRetry(() -> {
                try {
                    this.getStatementExecutor().invokeInterceptors(AbstractStatementParser.RUN_BATCH_STATEMENT, StatementExecutionStep.EXECUTE_STATEMENT, this);
                    long[] updateCounts = SpannerApiFutures.get(this.txContextFuture).batchUpdate(updateStatements, options);
                    this.createAndAddRetriableBatchUpdate(updateStatements, updateCounts, options);
                    return updateCounts;
                }
                catch (AbortedException e) {
                    throw e;
                }
                catch (SpannerException e) {
                    this.createAndAddFailedBatchUpdate(e, updateStatements);
                    throw e;
                }
            });
        }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteBatchDmlMethod())) : this.executeStatementAsync(AbstractStatementParser.RUN_BATCH_STATEMENT, () -> {
            this.checkTimedOut();
            this.checkAborted();
            return SpannerApiFutures.get(this.txContextFuture).batchUpdate(updateStatements, new Options.UpdateOption[0]);
        }, SpannerGrpc.getExecuteBatchDmlMethod());
        ApiFutures.addCallback(res, (ApiFutureCallback)new ApiFutureCallback<long[]>(){

            public void onFailure(Throwable t) {
                if (t instanceof SpannerException) {
                    ReadWriteTransaction.this.handlePossibleInvalidatingException((SpannerException)((Object)t));
                }
            }

            public void onSuccess(long[] result) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public ApiFuture<Void> writeAsync(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        this.checkValidTransaction();
        for (Mutation mutation : mutations) {
            this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
        }
        return ApiFutures.immediateFuture(null);
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        this.checkValidTransaction();
        this.state = UnitOfWork.UnitOfWorkState.COMMITTING;
        this.commitResponseFuture = SettableApiFuture.create();
        ApiFuture<Void> res = this.retryAbortsInternally ? this.executeStatementAsync(AbstractStatementParser.COMMIT_STATEMENT, () -> {
            this.checkTimedOut();
            try {
                return this.runWithRetry(() -> {
                    this.getStatementExecutor().invokeInterceptors(AbstractStatementParser.COMMIT_STATEMENT, StatementExecutionStep.EXECUTE_STATEMENT, this);
                    return this.commitCallable.call();
                });
            }
            catch (Throwable t) {
                this.commitResponseFuture.setException(t);
                this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                try {
                    this.txManager.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw t;
            }
        }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getCommitMethod())) : this.executeStatementAsync(AbstractStatementParser.COMMIT_STATEMENT, () -> {
            this.checkTimedOut();
            try {
                return this.commitCallable.call();
            }
            catch (Throwable t) {
                this.commitResponseFuture.setException(t);
                this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                try {
                    this.txManager.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw t;
            }
        }, SpannerGrpc.getCommitMethod());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runWithRetry(Callable<T> callable) throws SpannerException {
        while (true) {
            Object object = this.abortedLock;
            synchronized (object) {
                this.checkAborted();
                try {
                    return callable.call();
                }
                catch (AbortedException aborted) {
                    this.handleAborted(aborted);
                }
                catch (SpannerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw SpannerExceptionFactory.asSpannerException(e);
                }
            }
        }
    }

    private ResultSet createAndAddRetryResultSet(ResultSet resultSet, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (this.retryAbortsInternally) {
            ChecksumResultSet checksumResultSet = this.createChecksumResultSet(resultSet, statement, analyzeMode, options);
            this.addRetryStatement(checksumResultSet);
            return checksumResultSet;
        }
        return resultSet;
    }

    private void createAndAddFailedQuery(SpannerException e, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedQuery(this, e, statement, analyzeMode, options));
        }
    }

    private void createAndAddRetriableUpdate(AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, long updateCount, Options.UpdateOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new RetriableUpdate(this, update, analyzeMode, updateCount, options));
        }
    }

    private void createAndAddRetriableBatchUpdate(Iterable<Statement> updates, long[] updateCounts, Options.UpdateOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new RetriableBatchUpdate(this, updates, updateCounts, options));
        }
    }

    private void createAndAddFailedUpdate(SpannerException e, AbstractStatementParser.ParsedStatement update) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedUpdate(this, e, update));
        }
    }

    private void createAndAddFailedBatchUpdate(SpannerException e, Iterable<Statement> updates) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedBatchUpdate(this, e, updates));
        }
    }

    private void addRetryStatement(RetriableStatement statement) {
        Preconditions.checkState((boolean)this.retryAbortsInternally, (Object)"retryAbortsInternally is not enabled for this transaction");
        this.statements.add(statement);
    }

    private void handleAborted(AbortedException aborted) {
        block19: {
            if (this.transactionRetryAttempts >= 50) {
                this.throwAbortWithRetryAttemptsExceeded();
            } else {
                if (this.retryAbortsInternally) {
                    logger.fine(this.toString() + ": Starting internal transaction retry");
                    while (true) {
                        long delay = aborted.getRetryDelayInMillis();
                        try {
                            if (delay > 0L) {
                                Thread.sleep(delay);
                            }
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "The statement was cancelled");
                        }
                        try {
                            this.txContextFuture = ApiFutures.immediateFuture((Object)this.txManager.resetForRetry());
                            this.invokeTransactionRetryListenersOnStart();
                            ++this.transactionRetryAttempts;
                            for (RetriableStatement statement : this.statements) {
                                statement.retry(aborted);
                            }
                            ++this.successfulRetries;
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_SUCCESSFUL);
                            logger.fine(this.toString() + ": Internal transaction retry succeeded. Starting retry of original statement.");
                            break block19;
                        }
                        catch (AbortedDueToConcurrentModificationException e) {
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_DUE_TO_CONCURRENT_MODIFICATION);
                            logger.fine(this.toString() + ": Internal transaction retry aborted due to a concurrent modification");
                            try {
                                this.txManager.rollback();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                            this.abortedException = e;
                            throw e;
                        }
                        catch (AbortedException e) {
                            if (this.transactionRetryAttempts >= 50) {
                                this.throwAbortWithRetryAttemptsExceeded();
                            }
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_AND_RESTARTING);
                            logger.fine(this.toString() + ": Internal transaction retry aborted, trying again");
                            continue;
                        }
                        catch (SpannerException e) {
                            logger.log(Level.FINE, this.toString() + ": Internal transaction retry failed due to an unexpected exception", (Throwable)((Object)e));
                            try {
                                this.txManager.rollback();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                            this.abortedException = aborted;
                            throw e;
                        }
                        break;
                    }
                }
                try {
                    this.txManager.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                this.abortedException = aborted;
                throw aborted;
            }
        }
    }

    private void throwAbortWithRetryAttemptsExceeded() throws SpannerException {
        this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_AND_MAX_ATTEMPTS_EXCEEDED);
        logger.fine(this.toString() + ": Internal transaction retry aborted and max number of retry attempts has been exceeded");
        try {
            this.txManager.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
        this.abortedException = (AbortedException)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, MAX_INTERNAL_RETRIES_EXCEEDED);
        throw this.abortedException;
    }

    private void invokeTransactionRetryListenersOnStart() {
        for (TransactionRetryListener listener : this.transactionRetryListeners) {
            listener.retryStarting(this.transactionStarted, this.transactionId, this.transactionRetryAttempts);
        }
    }

    private void invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult result) {
        for (TransactionRetryListener listener : this.transactionRetryListeners) {
            listener.retryFinished(this.transactionStarted, this.transactionId, this.transactionRetryAttempts, result);
        }
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED || this.state == UnitOfWork.UnitOfWorkState.ABORTED, "This transaction has status " + this.state.name());
        this.state = UnitOfWork.UnitOfWorkState.ROLLED_BACK;
        if (this.txContextFuture != null && this.state != UnitOfWork.UnitOfWorkState.ABORTED) {
            return this.executeStatementAsync(AbstractStatementParser.ROLLBACK_STATEMENT, this.rollbackCallable, SpannerGrpc.getRollbackMethod());
        }
        return ApiFutures.immediateFuture(null);
    }

    @VisibleForTesting
    ChecksumResultSet createChecksumResultSet(ResultSet delegate, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        return new ChecksumResultSet(this, delegate, statement, analyzeMode, options);
    }

    static interface RetriableStatement {
        public void retry(AbortedException var1) throws AbortedException;
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, ReadWriteTransaction> {
        private DatabaseClient dbClient;
        private Boolean retryAbortsInternally;
        private boolean returnCommitStats;
        private List<TransactionRetryListener> transactionRetryListeners;

        private Builder() {
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setRetryAbortsInternally(boolean retryAbortsInternally) {
            this.retryAbortsInternally = retryAbortsInternally;
            return this;
        }

        Builder setReturnCommitStats(boolean returnCommitStats) {
            this.returnCommitStats = returnCommitStats;
            return this;
        }

        Builder setTransactionRetryListeners(List<TransactionRetryListener> listeners) {
            Preconditions.checkNotNull(listeners);
            this.transactionRetryListeners = listeners;
            return this;
        }

        @Override
        ReadWriteTransaction build() {
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.retryAbortsInternally != null ? 1 : 0) != 0, (Object)"RetryAbortsInternally is not specified");
            Preconditions.checkState((this.transactionRetryListeners != null ? 1 : 0) != 0, (Object)"TransactionRetryListeners are not specified");
            return new ReadWriteTransaction(this);
        }
    }
}

