/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Options;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.ClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.ModifiableClusterConfigurationParserFactory;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.runtime.util.bash.BashJavaUtils;
import org.apache.flink.util.FlinkException;

public class FlinkConfigLoader {
    public static Configuration loadConfiguration(String[] args) throws FlinkException {
        return ConfigurationParserUtils.loadCommonConfiguration(FlinkConfigLoader.filterCmdArgs(args, ClusterConfigurationParserFactory.options()), BashJavaUtils.class.getSimpleName());
    }

    public static List<String> loadAndModifyConfiguration(String[] args) throws FlinkException {
        return ConfigurationParserUtils.loadAndModifyConfiguration(FlinkConfigLoader.filterCmdArgs(args, ModifiableClusterConfigurationParserFactory.options()), BashJavaUtils.class.getSimpleName());
    }

    public static List<String> migrateLegacyConfigurationToStandardYaml(String[] args) throws FlinkException {
        return ConfigurationParserUtils.migrateLegacyConfigurationToStandardYaml(FlinkConfigLoader.filterCmdArgs(args, ClusterConfigurationParserFactory.options()), BashJavaUtils.class.getSimpleName());
    }

    private static String[] filterCmdArgs(String[] args, Options options) {
        ArrayList<String> filteredArgs = new ArrayList<String>();
        Iterator<String> iter = Arrays.asList(args).iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            if (options.hasOption(token)) {
                filteredArgs.add(token);
                if (!options.getOption(token).hasArg() || !iter.hasNext()) continue;
                filteredArgs.add(iter.next());
                continue;
            }
            if (!token.startsWith("-D")) continue;
            filteredArgs.add(token);
        }
        return filteredArgs.toArray(new String[0]);
    }

    private FlinkConfigLoader() {
    }
}

