/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execinfo;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.execinfo.ExecInfoMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.LabelComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExecInfoDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ExecInfoMeta.class;
    private MetaSelectionLine<ExecutionInfoLocation> wLocation;
    private CCombo wOperationType;
    private LabelComboVar wFieldId;
    private LabelComboVar wFieldParentId;
    private LabelComboVar wFieldName;
    private LabelComboVar wFieldType;
    private LabelComboVar wFieldChildren;
    private LabelComboVar wFieldLimit;
    private final ExecInfoMeta input;

    public ExecInfoDialog(Shell parent, IVariables variables, ExecInfoMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecInfoDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ExecInfoDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CCombo lastControl = this.wTransformName;
        this.wLocation = new MetaSelectionLine(this.variables, this.metadataProvider, ExecutionInfoLocation.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"ExecInfoDialog.Location.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.Location.Tooltip", (String[])new String[0]));
        PropsUi.setLook(this.wLocation);
        FormData fdLocation = new FormData();
        fdLocation.left = new FormAttachment(0, 0);
        fdLocation.top = new FormAttachment((Control)lastControl, margin);
        fdLocation.right = new FormAttachment(100, 0);
        this.wLocation.setLayoutData((Object)fdLocation);
        lastControl = this.wLocation;
        Label wlOperationType = new Label((Composite)this.shell, 131072);
        wlOperationType.setText(BaseMessages.getString(PKG, (String)"ExecInfoDialog.OperationType.Label", (String[])new String[0]));
        wlOperationType.setToolTipText(BaseMessages.getString(PKG, (String)"ExecInfoDialog.OperationType.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOperationType);
        FormData fdlOperationType = new FormData();
        fdlOperationType.left = new FormAttachment(0, 0);
        fdlOperationType.top = new FormAttachment(lastControl, margin);
        fdlOperationType.right = new FormAttachment(middle, 0);
        wlOperationType.setLayoutData((Object)fdlOperationType);
        this.wOperationType = new CCombo((Composite)this.shell, 18432);
        this.wOperationType.setToolTipText(BaseMessages.getString(PKG, (String)"ExecInfoDialog.OperationType.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOperationType);
        FormData fdOperationType = new FormData();
        fdOperationType.left = new FormAttachment(middle, margin);
        fdOperationType.top = new FormAttachment(lastControl, margin);
        fdOperationType.right = new FormAttachment(100, 0);
        this.wOperationType.setLayoutData((Object)fdOperationType);
        this.wOperationType.addListener(13, e -> this.enableFields());
        lastControl = this.wOperationType;
        this.wFieldId = new LabelComboVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldId.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldId.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldId);
        FormData fdFieldId = new FormData();
        fdFieldId.left = new FormAttachment(0, 0);
        fdFieldId.top = new FormAttachment((Control)lastControl, margin);
        fdFieldId.right = new FormAttachment(100, 0);
        this.wFieldId.setLayoutData((Object)fdFieldId);
        lastControl = this.wFieldId;
        this.wFieldParentId = new LabelComboVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldParentId.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldParentId.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldParentId);
        FormData fdFieldParentId = new FormData();
        fdFieldParentId.left = new FormAttachment(0, 0);
        fdFieldParentId.top = new FormAttachment((Control)lastControl, margin);
        fdFieldParentId.right = new FormAttachment(100, 0);
        this.wFieldParentId.setLayoutData((Object)fdFieldParentId);
        lastControl = this.wFieldParentId;
        this.wFieldName = new LabelComboVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldName);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(0, 0);
        fdFieldName.top = new FormAttachment((Control)lastControl, margin);
        fdFieldName.right = new FormAttachment(100, 0);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        lastControl = this.wFieldName;
        this.wFieldType = new LabelComboVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldType.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldType.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldType);
        FormData fdFieldType = new FormData();
        fdFieldType.left = new FormAttachment(0, 0);
        fdFieldType.top = new FormAttachment((Control)lastControl, margin);
        fdFieldType.right = new FormAttachment(100, 0);
        this.wFieldType.setLayoutData((Object)fdFieldType);
        lastControl = this.wFieldType;
        this.wFieldChildren = new LabelComboVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldChildren.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldChildren.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldChildren);
        FormData fdFieldChildren = new FormData();
        fdFieldChildren.left = new FormAttachment(0, 0);
        fdFieldChildren.top = new FormAttachment((Control)lastControl, margin);
        fdFieldChildren.right = new FormAttachment(100, 0);
        this.wFieldChildren.setLayoutData((Object)fdFieldChildren);
        lastControl = this.wFieldChildren;
        this.wFieldLimit = new LabelComboVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldLimit.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecInfoDialog.FieldLimit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFieldLimit);
        FormData fdFieldLimit = new FormData();
        fdFieldLimit.left = new FormAttachment(0, 0);
        fdFieldLimit.top = new FormAttachment((Control)lastControl, margin);
        fdFieldLimit.right = new FormAttachment(100, 0);
        this.wFieldLimit.setLayoutData((Object)fdFieldLimit);
        lastControl = this.wFieldLimit;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        this.getData();
        this.enableFields();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        String[] fieldNames;
        try {
            this.wLocation.fillItems();
        }
        catch (Exception e) {
            this.log.logError("Error getting a list of execution information locations", (Throwable)e);
        }
        this.wLocation.setText(Const.NVL((String)this.input.getLocation(), (String)""));
        this.wOperationType.setItems(ExecInfoMeta.OperationType.getDescriptions());
        this.wOperationType.setText(this.input.getOperationType() == null ? "" : this.input.getOperationType().getDescription());
        try {
            fieldNames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames();
        }
        catch (Exception e) {
            fieldNames = new String[]{};
        }
        this.wFieldId.setItems(fieldNames);
        this.wFieldId.setText(Const.NVL((String)this.input.getIdFieldName(), (String)""));
        this.wFieldParentId.setItems(fieldNames);
        this.wFieldParentId.setText(Const.NVL((String)this.input.getParentIdFieldName(), (String)""));
        this.wFieldChildren.setItems(fieldNames);
        this.wFieldChildren.setText(Const.NVL((String)this.input.getIncludeChildrenFieldName(), (String)""));
        this.wFieldName.setItems(fieldNames);
        this.wFieldName.setText(Const.NVL((String)this.input.getNameFieldName(), (String)""));
        this.wFieldType.setItems(fieldNames);
        this.wFieldType.setText(Const.NVL((String)this.input.getTypeFieldName(), (String)""));
        this.wFieldLimit.setItems(fieldNames);
        this.wFieldLimit.setText(Const.NVL((String)this.input.getLimitFieldName(), (String)""));
        this.enableFields();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void enableFields() {
        ExecInfoMeta.OperationType operationType = ExecInfoMeta.OperationType.getTypeByDescription(this.wOperationType.getText());
        this.wFieldId.setEnabled(operationType != null && operationType.isAcceptingExecutionId());
        this.wFieldParentId.setEnabled(operationType != null && operationType.isAcceptingParentExecutionId());
        this.wFieldName.setEnabled(operationType != null && operationType.isAcceptingName());
        this.wFieldType.setEnabled(operationType != null && operationType.isAcceptingExecutionType());
        this.wFieldChildren.setEnabled(operationType != null && operationType.isAcceptingIncludeChildren());
        this.wFieldLimit.setEnabled(operationType != null && operationType.isAcceptingLimit());
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setLocation(this.wLocation.getText());
        this.input.setOperationType(ExecInfoMeta.OperationType.getTypeByDescription(this.wOperationType.getText()));
        this.input.setIdFieldName(this.wFieldId.getText());
        this.input.setParentIdFieldName(this.wFieldParentId.getText());
        this.input.setNameFieldName(this.wFieldName.getText());
        this.input.setTypeFieldName(this.wFieldType.getText());
        this.input.setIncludeChildrenFieldName(this.wFieldChildren.getText());
        this.input.setLimitFieldName(this.wFieldLimit.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }
}

