/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.prefs.Preferences;
import org.apache.hop.core.util.IPluginProperty;
import org.apache.hop.core.util.KeyValue;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class BooleanPluginProperty
extends KeyValue<Boolean>
implements IPluginProperty {
    private static final long serialVersionUID = -2990345692552430357L;

    public BooleanPluginProperty(String key) throws IllegalArgumentException {
        super(key, DEFAULT_BOOLEAN_VALUE);
    }

    @Override
    public boolean evaluate() {
        return Boolean.TRUE.equals(this.getValue());
    }

    @Override
    public void appendXml(StringBuilder builder) {
        builder.append(XmlHandler.addTagValue((String)this.getKey(), (boolean)((Boolean)this.getValue())));
    }

    @Override
    public void loadXml(Node node) {
        String stringValue = XmlHandler.getTagValue((Node)node, (String)this.getKey());
        this.setValue("Y".equalsIgnoreCase(stringValue));
    }

    @Override
    public void saveToPreferences(Preferences node) {
        node.putBoolean(this.getKey(), (Boolean)this.getValue());
    }

    @Override
    public void readFromPreferences(Preferences node) {
        this.setValue(node.getBoolean(this.getKey(), (Boolean)this.getValue()));
    }
}

