/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldsplitter;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitter;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitterData;

@Transform(id="FieldSplitter", image="fieldsplitter.svg", name="i18n::SplitFields.Name", description="i18n::SplitFields.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::FieldSplitterMeta.keyword"}, documentationUrl="/pipeline/transforms/splitfields.html")
public class FieldSplitterMeta
extends BaseTransformMeta<FieldSplitter, FieldSplitterData> {
    private static final Class<?> PKG = FieldSplitterMeta.class;
    @HopMetadataProperty(key="splitfield", injectionKey="FIELD_TO_SPLIT", injectionKeyDescription="FieldSplitter.Injection.FIELD_TO_SPLIT")
    private String splitField;
    @HopMetadataProperty(key="delimiter", injectionKey="DELIMITER", injectionKeyDescription="FieldSplitter.Injection.DELIMITER")
    private String delimiter;
    @HopMetadataProperty(key="enclosure", injectionKey="ENCLOSURE", injectionKeyDescription="FieldSplitterDialog.Enclosure.Label")
    private String enclosure;
    @HopMetadataProperty(key="escape_string", injectionKey="ESCAPE_STRING", injectionKeyDescription="FieldSplitterDialog.EscapeString.Label")
    private String escapeString;
    @HopMetadataProperty(groupKey="fields", key="field", injectionKey="FIELD", injectionGroupKey="FIELDS", injectionKeyDescription="FieldSplitter.Injection.FIELDS")
    private List<FSField> fields = new ArrayList<FSField>();

    public FieldSplitterMeta() {
    }

    public FieldSplitterMeta(FieldSplitterMeta m) {
        this();
        this.splitField = m.splitField;
        this.delimiter = m.delimiter;
        this.enclosure = m.enclosure;
        this.escapeString = m.escapeString;
        m.fields.forEach(f -> this.fields.add(new FSField((FSField)f)));
    }

    public FieldSplitterMeta clone() {
        return new FieldSplitterMeta(this);
    }

    public void setDefault() {
        this.splitField = "";
        this.delimiter = ",";
        this.enclosure = null;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int idx = r.indexOfValue(this.getSplitField());
        if (idx < 0) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{this.getSplitField()}));
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            FSField field = this.fields.get(i);
            try {
                IValueMeta v = field.createValueMeta();
                v.setOrigin(name);
                if (i == 0) {
                    r.setValueMeta(idx, v);
                    continue;
                }
                if (idx >= r.size()) {
                    r.addValueMeta(v);
                }
                r.addValueMeta(idx + i, v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (prev != null && prev.size() > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta));
            int i = prev.indexOfValue(this.splitField);
            if (i < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldNotPresentInInputStream", (String[])new String[]{this.splitField}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldFoundInInputStream", (String[])new String[]{this.splitField}), (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.TransformReceivingInfoFromOtherTransform", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.NoInputReceivedFromOtherTransform", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }

    public List<FSField> getFields() {
        return this.fields;
    }

    public void setFields(List<FSField> fields) {
        this.fields = fields;
    }

    public static class FSField {
        @HopMetadataProperty(key="name", injectionKey="NAME", injectionKeyDescription="FieldSplitter.Injection.NAME")
        private String name;
        @HopMetadataProperty(key="id", injectionKey="ID", injectionKeyDescription="FieldSplitter.Injection.ID")
        private String id;
        @HopMetadataProperty(key="idrem", injectionKey="REMOVE_ID", injectionKeyDescription="FieldSplitter.Injection.REMOVE_ID")
        private boolean idRemoved;
        @HopMetadataProperty(key="type", injectionKey="DATA_TYPE", injectionKeyDescription="FieldSplitter.Injection.DATA_TYPE")
        private String type;
        @HopMetadataProperty(key="format", injectionKey="FORMAT", injectionKeyDescription="FieldSplitter.Injection.FORMAT")
        private String format;
        @HopMetadataProperty(key="group", injectionKey="GROUPING", injectionKeyDescription="FieldSplitter.Injection.GROUPING")
        private String group;
        @HopMetadataProperty(key="decimal", injectionKey="DECIMAL", injectionKeyDescription="FieldSplitter.Injection.DECIMAL")
        private String decimal;
        @HopMetadataProperty(key="currency", injectionKey="CURRENCY", injectionKeyDescription="FieldSplitter.Injection.CURRENCY")
        private String currency;
        @HopMetadataProperty(key="length", injectionKey="LENGTH", injectionKeyDescription="FieldSplitter.Injection.LENGTH")
        private int length;
        @HopMetadataProperty(key="precision", injectionKey="PRECISION", injectionKeyDescription="FieldSplitter.Injection.PRECISION")
        private int precision;
        @HopMetadataProperty(key="nullif", injectionKey="NULL_IF", injectionKeyDescription="FieldSplitter.Injection.NULL_IF")
        private String nullIf;
        @HopMetadataProperty(key="ifnull", injectionKey="DEFAULT", injectionKeyDescription="FieldSplitter.Injection.DEFAULT")
        private String ifNull;
        @HopMetadataProperty(key="trimtype", storeWithCode=true, injectionKey="TRIM_TYPE", injectionKeyDescription="FieldSplitter.Injection.TRIM_TYPE")
        private IValueMeta.TrimType trimType;

        public FSField() {
            this.trimType = IValueMeta.TrimType.NONE;
        }

        public FSField(FSField f) {
            this.name = f.name;
            this.id = f.id;
            this.idRemoved = f.idRemoved;
            this.type = f.type;
            this.format = f.format;
            this.group = f.group;
            this.decimal = f.decimal;
            this.currency = f.currency;
            this.length = f.length;
            this.precision = f.precision;
            this.nullIf = f.nullIf;
            this.ifNull = f.ifNull;
            this.trimType = f.trimType;
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta((String)this.type);
        }

        public IValueMeta createValueMeta() throws HopPluginException {
            int hopType = this.getHopType();
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)this.name, (int)hopType);
            valueMeta.setLength(this.length, this.precision);
            valueMeta.setConversionMask(this.format);
            valueMeta.setDecimalSymbol(this.decimal);
            valueMeta.setGroupingSymbol(this.group);
            valueMeta.setCurrencySymbol(this.currency);
            valueMeta.setTrimType(this.trimType.getType());
            return valueMeta;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isIdRemoved() {
            return this.idRemoved;
        }

        public void setIdRemoved(boolean idRemoved) {
            this.idRemoved = idRemoved;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public String getNullIf() {
            return this.nullIf;
        }

        public void setNullIf(String nullIf) {
            this.nullIf = nullIf;
        }

        public String getIfNull() {
            return this.ifNull;
        }

        public void setIfNull(String ifNull) {
            this.ifNull = ifNull;
        }

        public IValueMeta.TrimType getTrimType() {
            return this.trimType;
        }

        public void setTrimType(IValueMeta.TrimType trimType) {
            this.trimType = trimType;
        }
    }
}

