/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.fn.stream.PrefetchableIterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class PrefetchableIterables {
    private static final @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<@UnknownKeyFor @NonNull @Initialized Object> EMPTY_ITERABLE = new Default<Object>(){

        @Override
        protected @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<@UnknownKeyFor @NonNull @Initialized Object> createIterator() {
            return PrefetchableIterators.emptyIterator();
        }
    };

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<T> fromArray(final T ... values) {
        if (values.length == 0) {
            return PrefetchableIterables.emptyIterable();
        }
        return new Default<T>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> createIterator() {
                return PrefetchableIterators.fromArray(values);
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<T> maybePrefetchable(final @UnknownKeyFor @NonNull @Initialized Iterable<T> iterable) {
        if (iterable instanceof PrefetchableIterable) {
            return (PrefetchableIterable)iterable;
        }
        return new Default<T>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> createIterator() {
                return PrefetchableIterators.maybePrefetchable(iterable.iterator());
            }
        };
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<T> concat(final Iterable<T> ... iterables) {
        for (int i = 0; i < iterables.length; ++i) {
            if (iterables[i] != null) continue;
            throw new IllegalArgumentException("Iterable at position " + i + " was null.");
        }
        if (iterables.length == 0) {
            return PrefetchableIterables.emptyIterable();
        }
        if (iterables.length == 1) {
            return PrefetchableIterables.maybePrefetchable(iterables[0]);
        }
        return new Default<T>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> createIterator() {
                return PrefetchableIterators.concatIterators(FluentIterable.from((Object[])iterables).transform(Iterable::iterator).iterator());
            }
        };
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<T> limit(@UnknownKeyFor @NonNull @Initialized Iterable<T> iterable, final @UnknownKeyFor @NonNull @Initialized int limit) {
        final PrefetchableIterable<T> prefetchableIterable = PrefetchableIterables.maybePrefetchable(iterable);
        return new Default<T>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> createIterator() {
                return new PrefetchableIterator<T>(){
                    @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> delegate;
                    @UnknownKeyFor @NonNull @Initialized int currentPosition;
                    {
                        this.delegate = prefetchableIterable.iterator();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
                        if (this.currentPosition < limit) {
                            return this.delegate.isReady();
                        }
                        return true;
                    }

                    @Override
                    public void prefetch() {
                        if (!this.isReady()) {
                            this.delegate.prefetch();
                        }
                    }

                    @Override
                    @Pure
                    public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                        if (this.currentPosition != limit) {
                            return this.delegate.hasNext();
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.currentPosition;
                        return this.delegate.next();
                    }
                };
            }
        };
    }

    public static abstract class Default<@UnknownKeyFor T>
    implements PrefetchableIterable<T> {
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PrefetchableIterator<T> iterator = null;

        @Override
        public final void prefetch() {
            if (this.iterator != null) {
                return;
            }
            this.iterator = this.createIterator();
            this.iterator.prefetch();
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> iterator() {
            if (this.iterator == null) {
                return this.createIterator();
            }
            PrefetchableIterator<T> rval = this.iterator;
            this.iterator = null;
            return rval;
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> createIterator();
    }
}

