/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.model.fnexecution.v1.ProvisionApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.control.AutoValue_DefaultJobBundleFactory_ServerInfo;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandler;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandler;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.runners.fnexecution.control.MapControlClientPool;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.RemoteOutputReceiver;
import org.apache.beam.runners.fnexecution.control.SdkHarnessClient;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.data.GrpcDataService;
import org.apache.beam.runners.fnexecution.environment.DockerEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.EmbeddedEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.ExternalEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.ProcessEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.runners.fnexecution.logging.Slf4jLogWriter;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.runners.fnexecution.state.GrpcStateService;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.IdGenerators;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.server.GrpcContextHeaderAccessorProvider;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.NoopLock;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.sdk.util.construction.graph.ExecutableStage;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultJobBundleFactory
implements JobBundleFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DefaultJobBundleFactory.class);
    private static final @UnknownKeyFor @NonNull @Initialized IdGenerator factoryIdGenerator = IdGenerators.incrementingLongs();
    private final @UnknownKeyFor @NonNull @Initialized String factoryId = factoryIdGenerator.getId();
    private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized EnvironmentCacheAndLock> environmentCaches;
    private final @UnknownKeyFor @NonNull @Initialized AtomicInteger stageBundleFactoryCount = new AtomicInteger();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized EnvironmentFactory.Provider> environmentFactoryProviderMap;
    private final @UnknownKeyFor @NonNull @Initialized ExecutorService executor;
    private final @UnknownKeyFor @NonNull @Initialized MapControlClientPool clientPool;
    private final @UnknownKeyFor @NonNull @Initialized IdGenerator stageIdGenerator;
    private final @UnknownKeyFor @NonNull @Initialized int environmentExpirationMillis;
    private final @UnknownKeyFor @NonNull @Initialized Semaphore availableCachesSemaphore;
    private final @UnknownKeyFor @NonNull @Initialized LinkedBlockingDeque<@UnknownKeyFor @NonNull @Initialized EnvironmentCacheAndLock> availableCaches;
    private final @UnknownKeyFor @NonNull @Initialized boolean loadBalanceBundles;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient> evictedActiveClients;
    private @UnknownKeyFor @NonNull @Initialized boolean closed;

    public static @UnknownKeyFor @NonNull @Initialized DefaultJobBundleFactory create(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        PipelineOptions pipelineOptions = PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions());
        ImmutableMap environmentFactoryProviderMap = ImmutableMap.of((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER), (Object)new DockerEnvironmentFactory.Provider(pipelineOptions), (Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.PROCESS), (Object)new ProcessEnvironmentFactory.Provider(pipelineOptions), (Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL), (Object)new ExternalEnvironmentFactory.Provider(), (Object)"EMBEDDED", (Object)new EmbeddedEnvironmentFactory.Provider(pipelineOptions));
        return new DefaultJobBundleFactory(jobInfo, (Map<String, EnvironmentFactory.Provider>)environmentFactoryProviderMap);
    }

    public static @UnknownKeyFor @NonNull @Initialized DefaultJobBundleFactory create(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized EnvironmentFactory.Provider> environmentFactoryProviderMap) {
        return new DefaultJobBundleFactory(jobInfo, environmentFactoryProviderMap);
    }

    DefaultJobBundleFactory(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized EnvironmentFactory.Provider> environmentFactoryMap) {
        IdGenerator stageIdSuffixGenerator = IdGenerators.incrementingLongs();
        this.environmentFactoryProviderMap = environmentFactoryMap;
        this.executor = Executors.newCachedThreadPool();
        this.clientPool = MapControlClientPool.create();
        this.stageIdGenerator = () -> this.factoryId + "-" + stageIdSuffixGenerator.getId();
        this.environmentExpirationMillis = DefaultJobBundleFactory.getEnvironmentExpirationMillis(jobInfo);
        this.loadBalanceBundles = DefaultJobBundleFactory.shouldLoadBalanceBundles(jobInfo);
        this.environmentCaches = this.createEnvironmentCaches(serverFactory -> this.createServerInfo(jobInfo, (ServerFactory)serverFactory), DefaultJobBundleFactory.getMaxEnvironmentClients(jobInfo));
        this.availableCachesSemaphore = new Semaphore(this.environmentCaches.size(), true);
        this.availableCaches = new LinkedBlockingDeque<EnvironmentCacheAndLock>((Collection<EnvironmentCacheAndLock>)this.environmentCaches);
        this.evictedActiveClients = Sets.newConcurrentHashSet();
    }

    @VisibleForTesting
    DefaultJobBundleFactory(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized EnvironmentFactory.Provider> environmentFactoryMap, @UnknownKeyFor @NonNull @Initialized IdGenerator stageIdGenerator, @UnknownKeyFor @NonNull @Initialized ServerInfo serverInfo) {
        this.environmentFactoryProviderMap = environmentFactoryMap;
        this.executor = Executors.newCachedThreadPool();
        this.clientPool = MapControlClientPool.create();
        this.stageIdGenerator = stageIdGenerator;
        this.environmentExpirationMillis = DefaultJobBundleFactory.getEnvironmentExpirationMillis(jobInfo);
        this.loadBalanceBundles = DefaultJobBundleFactory.shouldLoadBalanceBundles(jobInfo);
        this.environmentCaches = this.createEnvironmentCaches(serverFactory -> serverInfo, DefaultJobBundleFactory.getMaxEnvironmentClients(jobInfo));
        this.availableCachesSemaphore = new Semaphore(this.environmentCaches.size(), true);
        this.availableCaches = new LinkedBlockingDeque<EnvironmentCacheAndLock>((Collection<EnvironmentCacheAndLock>)this.environmentCaches);
        this.evictedActiveClients = Sets.newConcurrentHashSet();
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized EnvironmentCacheAndLock> createEnvironmentCaches(final @UnknownKeyFor @NonNull @Initialized ThrowingFunction<@UnknownKeyFor @NonNull @Initialized ServerFactory, @UnknownKeyFor @NonNull @Initialized ServerInfo> serverInfoCreator, @UnknownKeyFor @NonNull @Initialized int count) {
        ImmutableList.Builder caches = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            Lock refLock = this.environmentExpirationMillis > 0 ? new ReentrantLock(true) : NoopLock.get();
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().removalListener(notification -> {
                int refCount;
                WrappedSdkHarnessClient client = (WrappedSdkHarnessClient)notification.getValue();
                refLock.lock();
                try {
                    refCount = client.unref();
                }
                finally {
                    refLock.unlock();
                }
                if (refCount > 0) {
                    LOG.warn("Expiring environment {} with {} remaining bundle references. Taking note to clean it up during shutdown if the references are not removed by then.", notification.getKey(), (Object)refCount);
                    this.evictedActiveClients.add(client);
                }
            });
            if (this.environmentExpirationMillis > 0) {
                cacheBuilder.expireAfterWrite((long)this.environmentExpirationMillis, TimeUnit.MILLISECONDS);
            }
            LoadingCache cache = cacheBuilder.build((CacheLoader)new CacheLoader<RunnerApi.Environment, WrappedSdkHarnessClient>(){

                public @UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient load(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    environment = Environments.resolveAnyOfEnvironment(environment, BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER));
                    EnvironmentFactory.Provider environmentFactoryProvider = (EnvironmentFactory.Provider)DefaultJobBundleFactory.this.environmentFactoryProviderMap.get(environment.getUrn());
                    ServerFactory serverFactory = environmentFactoryProvider.getServerFactory();
                    ServerInfo serverInfo = (ServerInfo)serverInfoCreator.apply(serverFactory);
                    String workerId = DefaultJobBundleFactory.this.stageIdGenerator.getId();
                    serverInfo.getProvisioningServer().getService().registerEnvironment(workerId, environment);
                    EnvironmentFactory environmentFactory = environmentFactoryProvider.createEnvironmentFactory(serverInfo.getControlServer(), serverInfo.getLoggingServer(), serverInfo.getRetrievalServer(), serverInfo.getProvisioningServer(), DefaultJobBundleFactory.this.clientPool, DefaultJobBundleFactory.this.stageIdGenerator);
                    return WrappedSdkHarnessClient.wrapping(environmentFactory.createEnvironment(environment, workerId), serverInfo);
                }
            });
            caches.add((Object)new EnvironmentCacheAndLock((LoadingCache<RunnerApi.Environment, WrappedSdkHarnessClient>)cache, refLock));
        }
        return caches.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized int getEnvironmentExpirationMillis(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        PipelineOptions pipelineOptions = PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions());
        return pipelineOptions.as(PortablePipelineOptions.class).getEnvironmentExpirationMillis();
    }

    private static @UnknownKeyFor @NonNull @Initialized int getMaxEnvironmentClients(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        PortablePipelineOptions pipelineOptions = PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
        int maxEnvironments = (Integer)MoreObjects.firstNonNull((Object)pipelineOptions.getSdkWorkerParallelism(), (Object)1);
        Preconditions.checkArgument((maxEnvironments >= 0 ? 1 : 0) != 0, (Object)"sdk_worker_parallelism must be >= 0");
        if (maxEnvironments == 0) {
            maxEnvironments = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        }
        return maxEnvironments;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean shouldLoadBalanceBundles(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        PipelineOptions pipelineOptions = PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions());
        boolean loadBalanceBundles = pipelineOptions.as(PortablePipelineOptions.class).getLoadBalanceBundles();
        if (loadBalanceBundles) {
            int stateCacheSize = Integer.parseInt((String)MoreObjects.firstNonNull((Object)ExperimentalOptions.getExperimentValue(pipelineOptions, "state_cache_size"), (Object)"0"));
            Preconditions.checkArgument((stateCacheSize == 0 ? 1 : 0) != 0, (String)"%s must be 0 when using bundle load balancing", (Object)"state_cache_size");
        }
        return loadBalanceBundles;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StageBundleFactory forStage(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
        return new SimpleStageBundleFactory(executableStage);
    }

    @Override
    public synchronized void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.closed) {
            return;
        }
        Exception exception = null;
        for (EnvironmentCacheAndLock environmentCache : this.environmentCaches) {
            try {
                environmentCache.cache.invalidateAll();
                environmentCache.cache.cleanUp();
            }
            catch (Exception e) {
                if (exception != null) {
                    exception.addSuppressed(e);
                    continue;
                }
                exception = e;
            }
        }
        for (WrappedSdkHarnessClient client : this.evictedActiveClients) {
            try {
                while (client.unref() > 0) {
                }
            }
            catch (Exception e) {
                if (exception != null) {
                    exception.addSuppressed(e);
                    continue;
                }
                exception = e;
            }
        }
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            if (exception != null) {
                exception.addSuppressed(e);
            }
            exception = e;
        }
        this.closed = true;
        if (exception != null) {
            throw exception;
        }
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RemoteOutputReceiver<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputReceivers(@UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor, @UnknownKeyFor @NonNull @Initialized OutputReceiverFactory outputReceiverFactory) {
        ImmutableMap.Builder outputReceivers = ImmutableMap.builder();
        for (Map.Entry<String, Coder> remoteOutputCoder : processBundleDescriptor.getRemoteOutputCoders().entrySet()) {
            String outputTransform = remoteOutputCoder.getKey();
            Coder coder = remoteOutputCoder.getValue();
            String bundleOutputPCollection = (String)Iterables.getOnlyElement(processBundleDescriptor.getProcessBundleDescriptor().getTransformsOrThrow(outputTransform).getInputsMap().values());
            FnDataReceiver outputReceiver = outputReceiverFactory.create(bundleOutputPCollection);
            outputReceivers.put((Object)outputTransform, (Object)RemoteOutputReceiver.of(coder, outputReceiver));
        }
        return outputReceivers.build();
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized RemoteOutputReceiver<@UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getTimerReceivers(@UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor, @UnknownKeyFor @NonNull @Initialized TimerReceiverFactory timerReceiverFactory) {
        ImmutableMap.Builder timerReceivers = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, ProcessBundleDescriptors.TimerSpec>> transformTimerSpecs : processBundleDescriptor.getTimerSpecs().entrySet()) {
            for (ProcessBundleDescriptors.TimerSpec timerSpec : transformTimerSpecs.getValue().values()) {
                FnDataReceiver receiver = timerReceiverFactory.create(timerSpec.transformId(), timerSpec.timerId());
                timerReceivers.put(KV.of(timerSpec.transformId(), timerSpec.timerId()), (Object)RemoteOutputReceiver.of(timerSpec.coder(), receiver));
            }
        }
        return timerReceivers.build();
    }

    private @UnknownKeyFor @NonNull @Initialized PreparedClient prepare(@UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient wrappedClient, @UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
        PreparedClient preparedClient = new PreparedClient();
        try {
            preparedClient.wrappedClient = wrappedClient;
            preparedClient.processBundleDescriptor = ProcessBundleDescriptors.fromExecutableStage(this.stageIdGenerator.getId(), executableStage, wrappedClient.getServerInfo().getDataServer().getApiServiceDescriptor(), wrappedClient.getServerInfo().getStateServer().getApiServiceDescriptor());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create ProcessBundleDescriptor.", e);
        }
        preparedClient.processor = wrappedClient.getClient().getProcessor(preparedClient.processBundleDescriptor.getProcessBundleDescriptor(), preparedClient.processBundleDescriptor.getRemoteInputDestinations(), wrappedClient.getServerInfo().getStateServer().getService(), preparedClient.processBundleDescriptor.getTimerSpecs());
        return preparedClient;
    }

    private @UnknownKeyFor @NonNull @Initialized ServerInfo createServerInfo(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized ServerFactory serverFactory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)serverFactory, (Object)"serverFactory can not be null");
        PortablePipelineOptions portableOptions = PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
        GrpcFnServer<FnApiControlClientPoolService> controlServer = GrpcFnServer.allocatePortAndCreateFor(FnApiControlClientPoolService.offeringClientsToPool(this.clientPool.getSink(), GrpcContextHeaderAccessorProvider.getHeaderAccessor()), serverFactory);
        GrpcFnServer<GrpcLoggingService> loggingServer = GrpcFnServer.allocatePortAndCreateFor(GrpcLoggingService.forWriter(Slf4jLogWriter.getDefault()), serverFactory);
        GrpcFnServer<ArtifactRetrievalService> retrievalServer = GrpcFnServer.allocatePortAndCreateFor(new ArtifactRetrievalService(), serverFactory);
        ProvisionApi.ProvisionInfo.Builder provisionInfo = jobInfo.toProvisionInfo().toBuilder();
        provisionInfo.setLoggingEndpoint(loggingServer.getApiServiceDescriptor());
        provisionInfo.setArtifactEndpoint(retrievalServer.getApiServiceDescriptor());
        provisionInfo.setControlEndpoint(controlServer.getApiServiceDescriptor());
        provisionInfo.addRunnerCapabilities(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardRunnerProtocols.Enum.CONTROL_RESPONSE_ELEMENTS_EMBEDDING));
        GrpcFnServer<StaticGrpcProvisionService> provisioningServer = GrpcFnServer.allocatePortAndCreateFor(StaticGrpcProvisionService.create(provisionInfo.build(), GrpcContextHeaderAccessorProvider.getHeaderAccessor()), serverFactory);
        GrpcFnServer<GrpcDataService> dataServer = GrpcFnServer.allocatePortAndCreateFor(GrpcDataService.create(portableOptions, this.executor, OutboundObserverFactory.serverDirect()), serverFactory);
        GrpcFnServer<GrpcStateService> stateServer = GrpcFnServer.allocatePortAndCreateFor(GrpcStateService.create(), serverFactory);
        ServerInfo serverInfo = new AutoValue_DefaultJobBundleFactory_ServerInfo.Builder().setControlServer(controlServer).setLoggingServer(loggingServer).setRetrievalServer(retrievalServer).setProvisioningServer(provisioningServer).setDataServer(dataServer).setStateServer(stateServer).build();
        return serverInfo;
    }

    @AutoValue
    public static abstract class ServerInfo {
        abstract @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> getControlServer();

        abstract @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> getLoggingServer();

        abstract @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService> getRetrievalServer();

        abstract @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> getProvisioningServer();

        abstract @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcDataService> getDataServer();

        abstract @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcStateService> getStateServer();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setControlServer(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setLoggingServer(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetrievalServer(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setProvisioningServer(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDataServer(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcDataService> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setStateServer(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcStateService> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ServerInfo build();
        }
    }

    protected static class WrappedSdkHarnessClient {
        private final @UnknownKeyFor @NonNull @Initialized RemoteEnvironment environment;
        private final @UnknownKeyFor @NonNull @Initialized SdkHarnessClient client;
        private final @UnknownKeyFor @NonNull @Initialized ServerInfo serverInfo;
        private final @UnknownKeyFor @NonNull @Initialized AtomicInteger bundleRefCount = new AtomicInteger();
        private @UnknownKeyFor @NonNull @Initialized boolean closed;

        static @UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient wrapping(@UnknownKeyFor @NonNull @Initialized RemoteEnvironment environment, @UnknownKeyFor @NonNull @Initialized ServerInfo serverInfo) {
            SdkHarnessClient client = SdkHarnessClient.usingFnApiClient(environment.getInstructionRequestHandler(), serverInfo.getDataServer().getService());
            return new WrappedSdkHarnessClient(environment, client, serverInfo);
        }

        private WrappedSdkHarnessClient(@UnknownKeyFor @NonNull @Initialized RemoteEnvironment environment, @UnknownKeyFor @NonNull @Initialized SdkHarnessClient client, @UnknownKeyFor @NonNull @Initialized ServerInfo serverInfo) {
            this.environment = environment;
            this.client = client;
            this.serverInfo = serverInfo;
            this.ref();
        }

        @UnknownKeyFor @NonNull @Initialized SdkHarnessClient getClient() {
            return this.client;
        }

        @UnknownKeyFor @NonNull @Initialized ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            try (RemoteEnvironment envCloser = this.environment;
                 GrpcFnServer<StaticGrpcProvisionService> provisioningServer = this.serverInfo.getProvisioningServer();
                 GrpcFnServer<ArtifactRetrievalService> retrievalServer = this.serverInfo.getRetrievalServer();
                 GrpcFnServer<GrpcStateService> stateServer = this.serverInfo.getStateServer();
                 GrpcFnServer<GrpcDataService> dataServer = this.serverInfo.getDataServer();
                 GrpcFnServer<FnApiControlClientPoolService> controlServer = this.serverInfo.getControlServer();
                 GrpcFnServer<GrpcLoggingService> loggingServer = this.serverInfo.getLoggingServer();){
                this.closed = true;
            }
            catch (Exception e) {
                LOG.warn("Error cleaning up servers {}", (Object)this.environment.getEnvironment(), (Object)e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized int ref() {
            return this.bundleRefCount.incrementAndGet();
        }

        private @UnknownKeyFor @NonNull @Initialized int unref() {
            int refCount = this.bundleRefCount.decrementAndGet();
            Preconditions.checkState((refCount >= 0 ? 1 : 0) != 0, (Object)"Reference count must not be negative.");
            if (refCount == 0) {
                LOG.info("Closing environment {}", (Object)this.environment.getEnvironment());
                this.close();
            }
            return refCount;
        }
    }

    private class SimpleStageBundleFactory
    implements StageBundleFactory {
        private final @UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage;
        private final @UnknownKeyFor @NonNull @Initialized int environmentIndex;
        private final @UnknownKeyFor @NonNull @Initialized IdentityHashMap<@UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient, @UnknownKeyFor @NonNull @Initialized PreparedClient> preparedClients = new IdentityHashMap();
        private volatile @UnknownKeyFor @NonNull @Initialized PreparedClient currentClient;

        private SimpleStageBundleFactory(ExecutableStage executableStage) {
            this.executableStage = executableStage;
            this.environmentIndex = DefaultJobBundleFactory.this.stageBundleFactoryCount.getAndIncrement() % DefaultJobBundleFactory.this.environmentCaches.size();
            WrappedSdkHarnessClient client = (WrappedSdkHarnessClient)((EnvironmentCacheAndLock)((DefaultJobBundleFactory)DefaultJobBundleFactory.this).environmentCaches.get((int)this.environmentIndex)).cache.getUnchecked((Object)executableStage.getEnvironment());
            this.currentClient = DefaultJobBundleFactory.this.prepare(client, executableStage);
            this.preparedClients.put(client, this.currentClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @UnknownKeyFor @NonNull @Initialized RemoteBundle getBundle(@UnknownKeyFor @NonNull @Initialized OutputReceiverFactory outputReceiverFactory, @UnknownKeyFor @NonNull @Initialized TimerReceiverFactory timerReceiverFactory, @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler, @UnknownKeyFor @NonNull @Initialized BundleProgressHandler progressHandler, @UnknownKeyFor @NonNull @Initialized BundleFinalizationHandler finalizationHandler, @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler checkpointHandler) throws @UnknownKeyFor @NonNull @Initialized Exception {
            WrappedSdkHarnessClient client;
            EnvironmentCacheAndLock currentCache;
            if (DefaultJobBundleFactory.this.loadBalanceBundles) {
                DefaultJobBundleFactory.this.availableCachesSemaphore.acquire();
                currentCache = (EnvironmentCacheAndLock)DefaultJobBundleFactory.this.availableCaches.take();
                currentCache.lock.lock();
                try {
                    client = (WrappedSdkHarnessClient)currentCache.cache.getUnchecked((Object)this.executableStage.getEnvironment());
                    client.ref();
                }
                finally {
                    currentCache.lock.unlock();
                }
                this.currentClient = this.preparedClients.get(client);
                if (this.currentClient == null) {
                    this.currentClient = DefaultJobBundleFactory.this.prepare(client, this.executableStage);
                    this.preparedClients.put(client, this.currentClient);
                    this.preparedClients.keySet().removeIf(c -> ((WrappedSdkHarnessClient)c).bundleRefCount.get() == 0);
                }
            } else {
                currentCache = (EnvironmentCacheAndLock)DefaultJobBundleFactory.this.environmentCaches.get(this.environmentIndex);
                currentCache.lock.lock();
                try {
                    client = (WrappedSdkHarnessClient)currentCache.cache.getUnchecked((Object)this.executableStage.getEnvironment());
                    client.ref();
                }
                finally {
                    currentCache.lock.unlock();
                }
                if (this.currentClient.wrappedClient != client) {
                    this.preparedClients.clear();
                    this.currentClient = DefaultJobBundleFactory.this.prepare(client, this.executableStage);
                    this.preparedClients.put(client, this.currentClient);
                }
            }
            if (DefaultJobBundleFactory.this.environmentExpirationMillis > 0) {
                DefaultJobBundleFactory.this.evictedActiveClients.removeIf(c -> ((WrappedSdkHarnessClient)c).bundleRefCount.get() == 0);
            }
            final SdkHarnessClient.BundleProcessor.ActiveBundle bundle = this.currentClient.processor.newBundle(DefaultJobBundleFactory.getOutputReceivers(this.currentClient.processBundleDescriptor, outputReceiverFactory), DefaultJobBundleFactory.getTimerReceivers(this.currentClient.processBundleDescriptor, timerReceiverFactory), stateRequestHandler, progressHandler, finalizationHandler, checkpointHandler);
            return new RemoteBundle(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getId() {
                    return bundle.getId();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FnDataReceiver> getInputReceivers() {
                    return bundle.getInputReceivers();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized Timer>> getTimerReceivers() {
                    return bundle.getTimerReceivers();
                }

                @Override
                public void requestProgress() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void split(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
                    bundle.split(fractionOfRemainder);
                }

                @Override
                public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
                    try {
                        bundle.close();
                    }
                    finally {
                        client.unref();
                        if (DefaultJobBundleFactory.this.loadBalanceBundles) {
                            DefaultJobBundleFactory.this.availableCaches.offer(currentCache);
                            DefaultJobBundleFactory.this.availableCachesSemaphore.release();
                        }
                    }
                }
            };
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor getProcessBundleDescriptor() {
            return this.currentClient.processBundleDescriptor;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler getInstructionRequestHandler() {
            return this.currentClient.wrappedClient.getClient().getInstructionRequestHandler();
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.preparedClients.clear();
        }
    }

    private static class PreparedClient {
        private @UnknownKeyFor @NonNull @Initialized SdkHarnessClient. @UnknownKeyFor @NonNull @Initialized BundleProcessor processor;
        private @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor;
        private @UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient wrappedClient;

        private PreparedClient() {
        }
    }

    private static class EnvironmentCacheAndLock {
        final @UnknownKeyFor @NonNull @Initialized Lock lock;
        final @UnknownKeyFor @NonNull @Initialized LoadingCache<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment, @UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient> cache;

        EnvironmentCacheAndLock(@UnknownKeyFor @NonNull @Initialized LoadingCache<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment, @UnknownKeyFor @NonNull @Initialized WrappedSdkHarnessClient> cache, @UnknownKeyFor @NonNull @Initialized Lock lock) {
            this.lock = lock;
            this.cache = cache;
        }
    }
}

