/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FloatSerializer
extends TypeSerializer<Float> {
    public static final FloatSerializer instance = new FloatSerializer();

    @Override
    public <V> Float deserialize(V value, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(value)) {
            return null;
        }
        return Float.valueOf(accessor.toFloat(value));
    }

    @Override
    public ByteBuffer serialize(Float value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.floatValue());
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 4 && !accessor.isEmpty(value)) {
            throw new MarshalException(String.format("Expected 4 or 0 byte value for a float (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Float value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }
}

