/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractMutableVirtualTable;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Pair;

final class PermissionsCacheKeysTable
extends AbstractMutableVirtualTable {
    private static final String ROLE = "role";
    private static final String RESOURCE = "resource";

    PermissionsCacheKeysTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "permissions_cache_keys").comment("keys in the permissions cache").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(ROLE, (AbstractType)UTF8Type.instance).addPartitionKeyColumn(RESOURCE, (AbstractType)UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        AuthenticatedUser.permissionsCache.getAll().forEach((userResoursePair, ignored) -> result.row(((AuthenticatedUser)userResoursePair.left).getName(), ((IResource)userResoursePair.right).getName()));
        return result;
    }

    @Override
    protected void applyPartitionDeletion(AbstractMutableVirtualTable.ColumnValues partitionKey) {
        AuthenticatedUser user = new AuthenticatedUser((String)partitionKey.value(0));
        IResource resource = this.resourceFromNameIfExists((String)partitionKey.value(1));
        if (resource == null) {
            return;
        }
        AuthenticatedUser.permissionsCache.invalidate(Pair.create(user, resource));
    }

    @Override
    public void truncate() {
        AuthenticatedUser.permissionsCache.invalidate();
    }

    private IResource resourceFromNameIfExists(String name) {
        try {
            return Resources.fromName(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

